/*
 * Decompiled with CFR 0.152.
 */
package io.github.givimad.whisperjni;

import io.github.givimad.whisperjni.WhisperJNI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class WhisperGrammar
extends WhisperJNI.WhisperJNIPointer {
    private final WhisperJNI whisper;
    private final String grammarText;

    protected WhisperGrammar(WhisperJNI whisper, int ref, String text) {
        super(ref);
        this.whisper = whisper;
        this.grammarText = text;
    }

    @Override
    public void close() {
        this.whisper.free(this);
    }

    public static void assertValidGrammar(Path grammar) throws ParseException, IOException {
        if (!Files.exists(grammar, new LinkOption[0])) {
            throw new ParseException("Grammar file does not exists.", 0);
        }
        WhisperGrammar.assertValidGrammar(Files.readString(grammar));
    }

    public static void assertValidGrammar(String grammarText) throws ParseException {
        if (grammarText.isBlank()) {
            throw new ParseException("Empty grammar.", 0);
        }
        Map<String, String> expressions = WhisperGrammar.parseExpressionsText(grammarText);
        String rootExpression = expressions.get("root");
        if (rootExpression == null) {
            throw new IllegalArgumentException("Missing root expression.");
        }
        WhisperGrammar.assertValidExpression(expressions, rootExpression, new ArrayList<String>(), new HashSet<String>(), true);
    }

    private static Map<String, String> parseExpressionsText(String gbnfGrammar) throws ParseException {
        String currentExpressionName = "";
        StringBuilder currentExpression = new StringBuilder();
        HashMap<String, String> expressions = new HashMap<String, String>();
        String assignSign = "::=";
        String[] split = gbnfGrammar.split("\n");
        for (int i = 0; i < split.length; ++i) {
            boolean isLast;
            String line = split[i];
            boolean bl = isLast = i == split.length - 1;
            if (line.isBlank() || line.trim().startsWith("#")) continue;
            boolean start = line.contains(assignSign);
            if (!start && currentExpressionName.isEmpty()) {
                throw new ParseException("Grammar should start with an expression", 0);
            }
            if (start) {
                String[] parts;
                if (!currentExpressionName.isBlank()) {
                    expressions.put(currentExpressionName, currentExpression.toString());
                }
                if ((currentExpressionName = (parts = line.split(assignSign))[0].trim()).isEmpty()) {
                    throw new ParseException("Missed expression name: " + line, 0);
                }
                currentExpression = new StringBuilder(parts[1].trim());
                if (!expressions.containsKey(currentExpressionName)) continue;
                throw new ParseException("Duplicated expression: " + currentExpressionName, 0);
            }
            currentExpression.append(" ").append(line.trim());
            if (!isLast) continue;
            String expression = currentExpression.toString();
            if (expression.isBlank()) {
                throw new ParseException("Missed expression value for: " + currentExpressionName, 0);
            }
            expressions.put(currentExpressionName, expression);
        }
        if (!expressions.containsKey(currentExpressionName)) {
            String expression = currentExpression.toString();
            if (expression.isBlank()) {
                throw new ParseException("Missed expression value for: " + currentExpressionName, 0);
            }
            expressions.put(currentExpressionName, expression);
        }
        return expressions;
    }

    private static void assertValidExpression(Map<String, String> expressions, String expressionText, ArrayList<String> parentExpressions, HashSet<String> validExpressions, boolean shouldTerminate) throws ParseException {
        boolean onText = false;
        boolean onRegex = false;
        int startRegexIndex = 0;
        int onGroup = 0;
        StringBuilder groupExpression = new StringBuilder();
        String[] tokens = expressionText.trim().split("\\s+");
        if (tokens.length == 1 && expressions.containsKey(tokens[0])) {
            if (parentExpressions.contains(tokens[0])) {
                throw new ParseException("Cyclic resolution of expression: " + tokens[0], 0);
            }
            parentExpressions = new ArrayList<String>(parentExpressions);
            parentExpressions.add(tokens[0]);
        }
        for (int i = 0; i < tokens.length; ++i) {
            String subExpressionValue;
            boolean isLast;
            String token = tokens[i];
            boolean bl = isLast = i == tokens.length - 1;
            if (token.isBlank()) continue;
            if (!onText && !onRegex) {
                int index;
                boolean isGroupEnd;
                boolean isGroupStart = token.startsWith("(");
                boolean isOptionalGroupEnd = token.endsWith(")?");
                boolean bl2 = isGroupEnd = token.endsWith(")") || isOptionalGroupEnd;
                if (isGroupStart) {
                    index = 0;
                    while (token.substring(index).startsWith("(")) {
                        ++onGroup;
                        ++index;
                    }
                }
                if (isGroupEnd) {
                    index = token.length();
                    String tmpToken = token.substring(0, index);
                    while (tmpToken.endsWith(")") || tmpToken.endsWith(")?")) {
                        --onGroup;
                        tmpToken = token.substring(0, index -= tmpToken.endsWith("?") ? 2 : 1);
                    }
                    if (onGroup < 0) {
                        throw new ParseException("Missing group open", 0);
                    }
                    if (token.length() > 1) {
                        groupExpression.append(" ").append(token, isGroupStart ? 1 : 0, token.length() - (isOptionalGroupEnd ? 2 : 1));
                    }
                    WhisperGrammar.assertValidExpression(expressions, groupExpression.toString(), parentExpressions, validExpressions, isLast && shouldTerminate);
                    groupExpression = new StringBuilder();
                    continue;
                }
                if (onGroup > 0) {
                    if (isGroupStart) {
                        groupExpression.append(token.substring(1));
                        continue;
                    }
                    groupExpression.append(" ").append(token);
                    continue;
                }
            }
            if (!onText && !onRegex && token.startsWith("\"")) {
                onText = true;
                if (token.length() == 1) continue;
            }
            if (!onRegex && onGroup == 0 && (token.endsWith("\"") || token.endsWith("\"?"))) {
                if (!onText) {
                    throw new ParseException("Missing string open on segment: " + expressionText, 0);
                }
                onText = false;
                continue;
            }
            if (onText) {
                if (!isLast || !shouldTerminate || token.endsWith(".")) continue;
                throw new ParseException("Root expression resolution should end with a dot.", 0);
            }
            if (!onRegex && onGroup == 0 && token.startsWith("[")) {
                onRegex = true;
                startRegexIndex = i;
                if (token.length() == 1) continue;
            }
            if (onGroup == 0 && (token.endsWith("]") || token.endsWith("]?") || token.endsWith("]+") || token.endsWith("]*"))) {
                if (!onRegex) {
                    throw new ParseException("Missing regex open on segment: ", 0);
                }
                onRegex = false;
                if (isLast && shouldTerminate) {
                    throw new ParseException("Root expression resolution should end with a dot.", 0);
                }
                String regexExpression = String.join((CharSequence)" ", Arrays.copyOfRange(tokens, startRegexIndex, i + 1));
                try {
                    String regexText = regexExpression.substring(1, regexExpression.lastIndexOf("]"));
                    Pattern.compile(regexText);
                    continue;
                }
                catch (PatternSyntaxException e) {
                    throw new ParseException("Invalid regex expression: " + regexExpression, 0);
                }
            }
            if (onRegex) continue;
            if (token.equals("|")) {
                WhisperGrammar.assertValidExpression(expressions, String.join((CharSequence)" ", Arrays.copyOfRange(tokens, i + 1, tokens.length)), parentExpressions, validExpressions, shouldTerminate);
                break;
            }
            String subExpression = token;
            if (subExpression.endsWith("?")) {
                subExpression = subExpression.substring(0, subExpression.length() - 1);
            }
            if ((subExpressionValue = expressions.get(subExpression)) == null) {
                throw new ParseException("Unable to resolve expression: " + subExpression, 0);
            }
            if ((!isLast || !shouldTerminate) && validExpressions.contains(subExpression)) continue;
            parentExpressions = new ArrayList<String>(parentExpressions);
            parentExpressions.add(subExpression);
            WhisperGrammar.assertValidExpression(expressions, subExpressionValue, parentExpressions, validExpressions, isLast && shouldTerminate);
            if (isLast && shouldTerminate) continue;
            validExpressions.add(subExpression);
        }
        if (onText) {
            throw new ParseException("Unclosed text at: " + expressionText, 0);
        }
        if (onRegex) {
            throw new ParseException("Unclosed regex at: " + expressionText, 0);
        }
        if (onGroup > 1) {
            throw new ParseException("Unclosed group at: " + expressionText, 0);
        }
    }
}

