/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.utils;

import io.github.linpeilie.processor.ContextConstants;
import io.github.linpeilie.processor.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class IncrementMarkUtils {
    public static Integer incrementAndGet() {
        int mark = 0;
        RandomAccessFile randomAccessFile = null;
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        try {
            File file = FileUtils.touch(new File(ContextConstants.AutoIncrementFile.file));
            randomAccessFile = new RandomAccessFile(file, "rw");
            channel = randomAccessFile.getChannel();
            lock = ((FileChannel)channel).lock();
            String line = randomAccessFile.readLine();
            if (line != null && !line.isEmpty()) {
                mark = Integer.parseInt(line);
                ++mark;
            }
            randomAccessFile.setLength(0L);
            randomAccessFile.seek(0L);
            randomAccessFile.writeBytes(String.valueOf(mark));
            Integer n = mark;
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (lock != null && lock.isValid()) {
                try {
                    lock.release();
                }
                catch (IOException iOException) {}
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

