/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie;

import io.github.linpeilie.BaseCycleAvoidingMapper;
import io.github.linpeilie.BaseMapMapper;
import io.github.linpeilie.BaseMapper;
import io.github.linpeilie.ConvertException;
import io.github.linpeilie.ConverterFactory;
import io.github.linpeilie.CycleAvoidingMappingContext;
import io.github.linpeilie.DefaultConverterFactory;
import io.github.linpeilie.utils.CollectionUtils;
import io.github.linpeilie.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Converter {
    private final ConverterFactory converterFactory;

    public Converter() {
        this.converterFactory = new DefaultConverterFactory();
    }

    public Converter(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    public <S, T> T convert(S source, Class<T> targetType) {
        if (ObjectUtils.isAnyNull(source, targetType)) {
            return null;
        }
        Class<?> sourceType = source.getClass();
        BaseMapper<?, T> mapper = this.converterFactory.getMapper(sourceType, targetType);
        if (ObjectUtils.isNull(mapper)) {
            throw new ConvertException("cannot find converter from " + sourceType.getSimpleName() + " to " + targetType.getSimpleName());
        }
        return mapper.convert(source);
    }

    public <S, T> T convert(S source, Class<T> targetType, Consumer<T> beanConsumer) {
        Class<T> bean = this.convert(source, (T)targetType);
        return (T)ObjectUtils.handleIfNull(bean, beanConsumer);
    }

    public <S, T> T convert(S source, T target) {
        Class<?> targetType;
        if (ObjectUtils.isAnyNull(source, target)) {
            return null;
        }
        Class<?> sourceType = source.getClass();
        BaseMapper<?, ?> mapper = this.converterFactory.getMapper(sourceType, targetType = target.getClass());
        if (ObjectUtils.isNull(mapper)) {
            throw new ConvertException("cannot find converter from " + sourceType.getSimpleName() + " to " + targetType.getSimpleName());
        }
        return (T)mapper.convert(source, target);
    }

    public <S, T> T convert(S source, T target, Consumer<T> beanConsumer) {
        T bean = this.convert(source, target);
        return ObjectUtils.handleIfNull(bean, beanConsumer);
    }

    public <S, T> List<T> convert(List<S> sourceList, Class<T> targetType) {
        return this.convert(sourceList, targetType, (Consumer)null);
    }

    public <S, T> List<T> convert(List<S> sourceList, Class<T> targetType, Consumer<T> beanConsumer) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return new ArrayList();
        }
        if (ObjectUtils.isNull(targetType)) {
            throw new ConvertException("targetType cannot be null");
        }
        Class<?> sourceType = sourceList.get(0).getClass();
        BaseMapper mapper = this.converterFactory.getMapper(sourceType, targetType);
        if (ObjectUtils.isNull(mapper)) {
            throw new ConvertException("cannot find converter from " + sourceType.getSimpleName() + " to " + targetType.getSimpleName());
        }
        if (ObjectUtils.isNotNull(beanConsumer)) {
            return CollectionUtils.toList(sourceList, source -> {
                Object bean = mapper.convert(source);
                beanConsumer.accept(bean);
                return bean;
            });
        }
        return mapper.convert(sourceList);
    }

    public <S, T> T convert(S source, Class<T> targetType, CycleAvoidingMappingContext context) {
        if (ObjectUtils.isAnyNull(source, targetType)) {
            return null;
        }
        Class<?> sourceType = source.getClass();
        BaseCycleAvoidingMapper<?, CycleAvoidingMappingContext> mapper = this.converterFactory.getCycleAvoidingMapper(sourceType, targetType);
        if (ObjectUtils.isNull(mapper)) {
            throw new ConvertException("cannot find converter from " + sourceType.getSimpleName() + " to " + targetType.getSimpleName());
        }
        return (T)mapper.convert(source, context);
    }

    public <S, T> T convert(S source, Class<T> targetType, CycleAvoidingMappingContext context, Consumer<T> beanConsumer) {
        T bean = this.convert(source, targetType, context);
        return ObjectUtils.handleIfNull(bean, beanConsumer);
    }

    public <S, T> List<T> convert(List<S> sourceList, Class<T> targetType, CycleAvoidingMappingContext context) {
        return this.convert(sourceList, targetType, context, (Consumer<T>)null);
    }

    public <S, T> List<T> convert(List<S> sourceList, Class<T> targetType, CycleAvoidingMappingContext context, Consumer<T> beanConsumer) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return new ArrayList();
        }
        if (ObjectUtils.isNull(targetType)) {
            throw new ConvertException("targetType cannot be null");
        }
        Class<?> sourceType = sourceList.get(0).getClass();
        BaseCycleAvoidingMapper<?, CycleAvoidingMappingContext> mapper = this.converterFactory.getCycleAvoidingMapper(sourceType, targetType);
        if (ObjectUtils.isNull(mapper)) {
            throw new ConvertException("cannot find converter from " + sourceType.getSimpleName() + " to " + targetType.getSimpleName());
        }
        if (ObjectUtils.isNotNull(beanConsumer)) {
            return CollectionUtils.toList(sourceList, source -> {
                CycleAvoidingMappingContext bean = mapper.convert(source, context);
                beanConsumer.accept(bean);
                return bean;
            });
        }
        return mapper.convert(sourceList, context);
    }

    public <T> T convert(Map<String, Object> map, Class<T> targetType) {
        if (CollectionUtils.isEmpty(map) || map.values().stream().allMatch(Objects::isNull)) {
            return null;
        }
        if (ObjectUtils.isNull(targetType)) {
            throw new ConvertException("targetType cannot be null");
        }
        BaseMapMapper<T> mapper = this.converterFactory.getMapMapper(targetType);
        if (ObjectUtils.isNull(mapper)) {
            throw new ConvertException("cannot find converter from " + map.getClass().getName() + " to " + targetType.getSimpleName());
        }
        return mapper.convert(map);
    }

    public <T> T convert(Map<String, Object> map, Class<T> targetType, Consumer<T> beanConsumer) {
        T bean = this.convert(map, targetType);
        return ObjectUtils.handleIfNull(bean, beanConsumer);
    }
}

