/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.config;

import com.dtp.common.constant.DynamicTpConst;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.QueueTypeEnum;
import com.dtp.common.em.RejectedTypeEnum;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ThreadPoolProperties {
    private String threadPoolName = "DynamicTp";
    private int corePoolSize = 1;
    private int maximumPoolSize = DynamicTpConst.AVAILABLE_PROCESSORS;
    private int queueCapacity = 1024;
    private String queueType = QueueTypeEnum.VARIABLE_LINKED_BLOCKING_QUEUE.getName();
    private boolean fair = false;
    private String rejectedHandlerType = RejectedTypeEnum.CALLER_RUNS_POLICY.getName();
    private long keepAliveTime = 30L;
    private TimeUnit unit = TimeUnit.SECONDS;
    private boolean allowCoreThreadTimeOut = false;
    private String threadNamePrefix = "dynamic-tp";
    private List<NotifyItem> notifyItems;

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public String getQueueType() {
        return this.queueType;
    }

    public boolean isFair() {
        return this.fair;
    }

    public String getRejectedHandlerType() {
        return this.rejectedHandlerType;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public boolean isAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public List<NotifyItem> getNotifyItems() {
        return this.notifyItems;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setQueueType(String queueType) {
        this.queueType = queueType;
    }

    public void setFair(boolean fair) {
        this.fair = fair;
    }

    public void setRejectedHandlerType(String rejectedHandlerType) {
        this.rejectedHandlerType = rejectedHandlerType;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public void setNotifyItems(List<NotifyItem> notifyItems) {
        this.notifyItems = notifyItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolProperties)) {
            return false;
        }
        ThreadPoolProperties other = (ThreadPoolProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        if (this.getQueueCapacity() != other.getQueueCapacity()) {
            return false;
        }
        if (this.isFair() != other.isFair()) {
            return false;
        }
        if (this.getKeepAliveTime() != other.getKeepAliveTime()) {
            return false;
        }
        if (this.isAllowCoreThreadTimeOut() != other.isAllowCoreThreadTimeOut()) {
            return false;
        }
        String this$threadPoolName = this.getThreadPoolName();
        String other$threadPoolName = other.getThreadPoolName();
        if (this$threadPoolName == null ? other$threadPoolName != null : !this$threadPoolName.equals(other$threadPoolName)) {
            return false;
        }
        String this$queueType = this.getQueueType();
        String other$queueType = other.getQueueType();
        if (this$queueType == null ? other$queueType != null : !this$queueType.equals(other$queueType)) {
            return false;
        }
        String this$rejectedHandlerType = this.getRejectedHandlerType();
        String other$rejectedHandlerType = other.getRejectedHandlerType();
        if (this$rejectedHandlerType == null ? other$rejectedHandlerType != null : !this$rejectedHandlerType.equals(other$rejectedHandlerType)) {
            return false;
        }
        TimeUnit this$unit = this.getUnit();
        TimeUnit other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit)) {
            return false;
        }
        String this$threadNamePrefix = this.getThreadNamePrefix();
        String other$threadNamePrefix = other.getThreadNamePrefix();
        if (this$threadNamePrefix == null ? other$threadNamePrefix != null : !this$threadNamePrefix.equals(other$threadNamePrefix)) {
            return false;
        }
        List<NotifyItem> this$notifyItems = this.getNotifyItems();
        List<NotifyItem> other$notifyItems = other.getNotifyItems();
        return !(this$notifyItems == null ? other$notifyItems != null : !((Object)this$notifyItems).equals(other$notifyItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaximumPoolSize();
        result = result * 59 + this.getQueueCapacity();
        result = result * 59 + (this.isFair() ? 79 : 97);
        long $keepAliveTime = this.getKeepAliveTime();
        result = result * 59 + (int)($keepAliveTime >>> 32 ^ $keepAliveTime);
        result = result * 59 + (this.isAllowCoreThreadTimeOut() ? 79 : 97);
        String $threadPoolName = this.getThreadPoolName();
        result = result * 59 + ($threadPoolName == null ? 43 : $threadPoolName.hashCode());
        String $queueType = this.getQueueType();
        result = result * 59 + ($queueType == null ? 43 : $queueType.hashCode());
        String $rejectedHandlerType = this.getRejectedHandlerType();
        result = result * 59 + ($rejectedHandlerType == null ? 43 : $rejectedHandlerType.hashCode());
        TimeUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        String $threadNamePrefix = this.getThreadNamePrefix();
        result = result * 59 + ($threadNamePrefix == null ? 43 : $threadNamePrefix.hashCode());
        List<NotifyItem> $notifyItems = this.getNotifyItems();
        result = result * 59 + ($notifyItems == null ? 43 : ((Object)$notifyItems).hashCode());
        return result;
    }

    public String toString() {
        return "ThreadPoolProperties(threadPoolName=" + this.getThreadPoolName() + ", corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", queueCapacity=" + this.getQueueCapacity() + ", queueType=" + this.getQueueType() + ", fair=" + this.isFair() + ", rejectedHandlerType=" + this.getRejectedHandlerType() + ", keepAliveTime=" + this.getKeepAliveTime() + ", unit=" + (Object)((Object)this.getUnit()) + ", allowCoreThreadTimeOut=" + this.isAllowCoreThreadTimeOut() + ", threadNamePrefix=" + this.getThreadNamePrefix() + ", notifyItems=" + this.getNotifyItems() + ")";
    }
}

