/*
 * Decompiled with CFR 0.152.
 */
package io.github.mymonstercat.ocr;

import io.github.mymonstercat.loader.LibraryLoader;
import io.github.mymonstercat.loader.ModelsLoader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;

public class LoadUtil {
    private LoadUtil() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LibraryLoader findLibLoader(String engine) {
        Properties props = new Properties();
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("load/loaders.properties");){
            String loaderClassName;
            block19: {
                String osArch;
                String osName;
                block18: {
                    if (input == null) {
                        throw new FileNotFoundException("\u5728\u52a0\u8f7d\u76ee\u5f55\u4e2d\u627e\u4e0d\u5230loaders.properties");
                    }
                    props.load(input);
                    osName = System.getProperty("os.name").toLowerCase();
                    osArch = System.getProperty("os.arch").toLowerCase();
                    loaderClassName = null;
                    if (!osName.contains("win")) break block18;
                    if (osArch.contains("amd64")) {
                        loaderClassName = props.getProperty(engine + ".win-x86_64");
                        break block19;
                    } else if (osArch.contains("x86")) {
                        loaderClassName = props.getProperty(engine + ".win-x86");
                    }
                    break block19;
                }
                if (osName.contains("mac")) {
                    loaderClassName = osArch.contains("arch64") ? props.getProperty(engine + ".mac-arm64") : props.getProperty(engine + ".mac-x86_64");
                } else if (osName.contains("linux")) {
                    if (osArch.contains("x86") || osArch.contains("amd64")) {
                        loaderClassName = props.getProperty(engine + ".linux-x86_64");
                    } else if (osArch.contains("arm")) {
                        loaderClassName = props.getProperty("linuxArmLoader");
                    }
                }
            }
            if (loaderClassName == null) return null;
            LibraryLoader libraryLoader = (LibraryLoader)Class.forName(loaderClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return libraryLoader;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ModelsLoader findModelsLoader(String engine) {
        ModelsLoader modelsLoader;
        block9: {
            Properties props = new Properties();
            InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("load/loaders.properties");
            try {
                if (input == null) {
                    throw new FileNotFoundException("\u5728\u52a0\u8f7d\u76ee\u5f55\u4e2d\u627e\u4e0d\u5230loaders.properties");
                }
                props.load(input);
                modelsLoader = (ModelsLoader)Class.forName(props.getProperty(engine + ".model")).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            input.close();
        }
        return modelsLoader;
    }
}

