/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import java.time.Duration;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BulkheadConfig {
    public static final int DEFAULT_MAX_CONCURRENT_CALLS = 25;
    public static final Duration DEFAULT_MAX_WAIT_DURATION = Duration.ofSeconds(0L);
    public static final boolean DEFAULT_WRITABLE_STACK_TRACE_ENABLED = true;
    public static final boolean DEFAULT_FAIR_CALL_HANDLING_STRATEGY_ENABLED = true;
    private final int maxConcurrentCalls;
    private final Duration maxWaitDuration;
    private final boolean writableStackTraceEnabled;
    private final boolean fairCallHandlingEnabled;

    private BulkheadConfig(int maxConcurrentCalls, Duration maxWaitDuration, boolean writableStackTraceEnabled, boolean fairCallHandlingEnabled) {
        this.maxConcurrentCalls = maxConcurrentCalls;
        this.maxWaitDuration = maxWaitDuration;
        this.writableStackTraceEnabled = writableStackTraceEnabled;
        this.fairCallHandlingEnabled = fairCallHandlingEnabled;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(BulkheadConfig baseConfig) {
        return new Builder(baseConfig);
    }

    public static BulkheadConfig ofDefaults() {
        return new Builder().build();
    }

    public int getMaxConcurrentCalls() {
        return this.maxConcurrentCalls;
    }

    public Duration getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    public boolean isWritableStackTraceEnabled() {
        return this.writableStackTraceEnabled;
    }

    public boolean isFairCallHandlingEnabled() {
        return this.fairCallHandlingEnabled;
    }

    public static class Builder {
        private int maxConcurrentCalls;
        private Duration maxWaitDuration;
        private boolean writableStackTraceEnabled;
        private boolean fairCallHandlingEnabled;

        public Builder() {
            this.maxConcurrentCalls = 25;
            this.maxWaitDuration = DEFAULT_MAX_WAIT_DURATION;
            this.writableStackTraceEnabled = true;
            this.fairCallHandlingEnabled = true;
        }

        public Builder(BulkheadConfig bulkheadConfig) {
            this.maxConcurrentCalls = bulkheadConfig.getMaxConcurrentCalls();
            this.maxWaitDuration = bulkheadConfig.getMaxWaitDuration();
            this.writableStackTraceEnabled = bulkheadConfig.isWritableStackTraceEnabled();
            this.fairCallHandlingEnabled = bulkheadConfig.isFairCallHandlingEnabled();
        }

        public Builder maxConcurrentCalls(int maxConcurrentCalls) {
            if (maxConcurrentCalls < 0) {
                throw new IllegalArgumentException("maxConcurrentCalls must be an integer value >= 0");
            }
            this.maxConcurrentCalls = maxConcurrentCalls;
            return this;
        }

        public Builder maxWaitDuration(Duration maxWaitDuration) {
            if (maxWaitDuration.toMillis() < 0L) {
                throw new IllegalArgumentException("maxWaitDuration must be a positive integer value >= 0");
            }
            this.maxWaitDuration = maxWaitDuration;
            return this;
        }

        public Builder writableStackTraceEnabled(boolean writableStackTraceEnabled) {
            this.writableStackTraceEnabled = writableStackTraceEnabled;
            return this;
        }

        public Builder fairCallHandlingStrategyEnabled(boolean fairCallHandlingEnabled) {
            this.fairCallHandlingEnabled = fairCallHandlingEnabled;
            return this;
        }

        public BulkheadConfig build() {
            return new BulkheadConfig(this.maxConcurrentCalls, this.maxWaitDuration, this.writableStackTraceEnabled, this.fairCallHandlingEnabled);
        }
    }
}

