/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.circuitbreaker.configuration;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.common.CommonProperties;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.circuitbreaker.configuration.CircuitBreakerConfigCustomizer;
import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ClassUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CircuitBreakerConfigurationProperties
extends CommonProperties {
    private Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public Optional<InstanceProperties> findCircuitBreakerProperties(String name) {
        InstanceProperties instanceProperties = this.instances.get(name);
        if (instanceProperties == null) {
            instanceProperties = this.configs.get("default");
        }
        return Optional.ofNullable(instanceProperties);
    }

    public CircuitBreakerConfig createCircuitBreakerConfig(String backendName, InstanceProperties instanceProperties, CompositeCustomizer<CircuitBreakerConfigCustomizer> compositeCircuitBreakerCustomizer) {
        if (StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            return this.buildConfigFromBaseConfig(instanceProperties, baseProperties, compositeCircuitBreakerCustomizer, backendName);
        }
        return this.buildConfig(CircuitBreakerConfig.custom(), instanceProperties, compositeCircuitBreakerCustomizer, backendName);
    }

    private CircuitBreakerConfig buildConfigFromBaseConfig(InstanceProperties instanceProperties, InstanceProperties baseProperties, CompositeCustomizer<CircuitBreakerConfigCustomizer> compositeCircuitBreakerCustomizer, String backendName) {
        ConfigUtils.mergePropertiesIfAny(instanceProperties, baseProperties);
        CircuitBreakerConfig baseConfig = this.buildConfig(CircuitBreakerConfig.custom(), baseProperties, compositeCircuitBreakerCustomizer, backendName);
        return this.buildConfig(CircuitBreakerConfig.from((CircuitBreakerConfig)baseConfig), instanceProperties, compositeCircuitBreakerCustomizer, backendName);
    }

    private CircuitBreakerConfig buildConfig(CircuitBreakerConfig.Builder builder, InstanceProperties properties, CompositeCustomizer<CircuitBreakerConfigCustomizer> compositeCircuitBreakerCustomizer, String backendName) {
        if (properties == null) {
            return builder.build();
        }
        if (properties.enableExponentialBackoff != null && properties.enableExponentialBackoff.booleanValue() && properties.enableRandomizedWait != null && properties.enableRandomizedWait.booleanValue()) {
            throw new IllegalStateException("you can not enable Exponential backoff policy and randomized delay at the same time , please enable only one of them");
        }
        this.configureCircuitBreakerOpenStateIntervalFunction(properties, builder);
        if (properties.getFailureRateThreshold() != null) {
            builder.failureRateThreshold(properties.getFailureRateThreshold().floatValue());
        }
        if (properties.getWritableStackTraceEnabled() != null) {
            builder.writableStackTraceEnabled(properties.getWritableStackTraceEnabled().booleanValue());
        }
        if (properties.getSlowCallRateThreshold() != null) {
            builder.slowCallRateThreshold(properties.getSlowCallRateThreshold().floatValue());
        }
        if (properties.getSlowCallDurationThreshold() != null) {
            builder.slowCallDurationThreshold(properties.getSlowCallDurationThreshold());
        }
        if (properties.getRingBufferSizeInClosedState() != null) {
            builder.ringBufferSizeInClosedState(properties.getRingBufferSizeInClosedState().intValue());
        }
        if (properties.getSlidingWindowSize() != null) {
            builder.slidingWindowSize(properties.getSlidingWindowSize().intValue());
        }
        if (properties.getMinimumNumberOfCalls() != null) {
            builder.minimumNumberOfCalls(properties.getMinimumNumberOfCalls().intValue());
        }
        if (properties.getSlidingWindowType() != null) {
            builder.slidingWindowType(properties.getSlidingWindowType());
        }
        if (properties.getRingBufferSizeInHalfOpenState() != null) {
            builder.ringBufferSizeInHalfOpenState(properties.getRingBufferSizeInHalfOpenState().intValue());
        }
        if (properties.getPermittedNumberOfCallsInHalfOpenState() != null) {
            builder.permittedNumberOfCallsInHalfOpenState(properties.getPermittedNumberOfCallsInHalfOpenState().intValue());
        }
        if (properties.recordFailurePredicate != null) {
            this.buildRecordFailurePredicate(properties, builder);
        }
        if (properties.recordExceptions != null) {
            builder.recordExceptions(properties.recordExceptions);
        }
        if (properties.ignoreExceptions != null) {
            builder.ignoreExceptions(properties.ignoreExceptions);
        }
        if (properties.automaticTransitionFromOpenToHalfOpenEnabled != null) {
            builder.automaticTransitionFromOpenToHalfOpenEnabled(properties.automaticTransitionFromOpenToHalfOpenEnabled.booleanValue());
        }
        compositeCircuitBreakerCustomizer.getCustomizer(backendName).ifPresent(circuitBreakerConfigCustomizer -> circuitBreakerConfigCustomizer.customize(builder));
        return builder.build();
    }

    private void configureCircuitBreakerOpenStateIntervalFunction(InstanceProperties properties, CircuitBreakerConfig.Builder builder) {
        if (properties.getWaitDurationInOpenState() != null && properties.getWaitDurationInOpenState().toMillis() > 0L) {
            Duration waitDuration = properties.getWaitDurationInOpenState();
            if (properties.getEnableExponentialBackoff() != null && properties.getEnableExponentialBackoff().booleanValue()) {
                if (properties.getExponentialBackoffMultiplier() != null) {
                    builder.waitIntervalFunctionInOpenState(IntervalFunction.ofExponentialBackoff((long)waitDuration.toMillis(), (double)properties.getExponentialBackoffMultiplier()));
                } else {
                    builder.waitIntervalFunctionInOpenState(IntervalFunction.ofExponentialBackoff((long)properties.getWaitDurationInOpenState().toMillis()));
                }
            } else if (properties.getEnableRandomizedWait() != null && properties.getEnableRandomizedWait().booleanValue()) {
                if (properties.getRandomizedWaitFactor() != null) {
                    builder.waitIntervalFunctionInOpenState(IntervalFunction.ofRandomized((long)waitDuration.toMillis(), (double)properties.getRandomizedWaitFactor()));
                } else {
                    builder.waitIntervalFunctionInOpenState(IntervalFunction.ofRandomized((Duration)waitDuration));
                }
            } else {
                builder.waitDurationInOpenState(properties.getWaitDurationInOpenState());
            }
        }
    }

    private void buildRecordFailurePredicate(InstanceProperties properties, CircuitBreakerConfig.Builder builder) {
        Predicate predicate;
        if (properties.getRecordFailurePredicate() != null && (predicate = ClassUtils.instantiatePredicateClass(properties.getRecordFailurePredicate())) != null) {
            builder.recordException(predicate);
        }
    }

    @Nullable
    public InstanceProperties getBackendProperties(String backend) {
        return this.instances.get(backend);
    }

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getBackends() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    public static class InstanceProperties {
        @Nullable
        private Duration waitDurationInOpenState;
        @Nullable
        private Duration slowCallDurationThreshold;
        @Nullable
        private Float failureRateThreshold;
        @Nullable
        private Float slowCallRateThreshold;
        @Nullable
        @Deprecated
        private Integer ringBufferSizeInClosedState;
        @Nullable
        private CircuitBreakerConfig.SlidingWindowType slidingWindowType;
        @Nullable
        private Integer slidingWindowSize;
        @Nullable
        private Integer minimumNumberOfCalls;
        @Nullable
        private Integer permittedNumberOfCallsInHalfOpenState;
        @Nullable
        @Deprecated
        private Integer ringBufferSizeInHalfOpenState;
        @Nullable
        private Boolean automaticTransitionFromOpenToHalfOpenEnabled;
        @Nullable
        private Boolean writableStackTraceEnabled;
        @Nullable
        private Boolean allowHealthIndicatorToFail;
        @Nullable
        private Integer eventConsumerBufferSize;
        @Nullable
        private Boolean registerHealthIndicator;
        @Nullable
        private Class<Predicate<Throwable>> recordFailurePredicate;
        @Nullable
        private Class<? extends Throwable>[] recordExceptions;
        @Nullable
        private Class<? extends Throwable>[] ignoreExceptions;
        @Nullable
        private String baseConfig;
        @Nullable
        private Boolean enableExponentialBackoff;
        private Double exponentialBackoffMultiplier;
        @Nullable
        private Boolean enableRandomizedWait;
        private Double randomizedWaitFactor;

        @Nullable
        public Float getFailureRateThreshold() {
            return this.failureRateThreshold;
        }

        public InstanceProperties setFailureRateThreshold(Float failureRateThreshold) {
            Objects.requireNonNull(failureRateThreshold);
            if (failureRateThreshold.floatValue() < 1.0f || failureRateThreshold.floatValue() > 100.0f) {
                throw new IllegalArgumentException("failureRateThreshold must be between 1 and 100.");
            }
            this.failureRateThreshold = failureRateThreshold;
            return this;
        }

        @Nullable
        public Duration getWaitDurationInOpenState() {
            return this.waitDurationInOpenState;
        }

        public InstanceProperties setWaitDurationInOpenState(Duration waitDurationInOpenStateMillis) {
            Objects.requireNonNull(waitDurationInOpenStateMillis);
            if (waitDurationInOpenStateMillis.toMillis() < 1L) {
                throw new IllegalArgumentException("waitDurationInOpenStateMillis must be greater than or equal to 1 millis.");
            }
            this.waitDurationInOpenState = waitDurationInOpenStateMillis;
            return this;
        }

        @Nullable
        public Integer getRingBufferSizeInClosedState() {
            return this.ringBufferSizeInClosedState;
        }

        @Deprecated
        public InstanceProperties setRingBufferSizeInClosedState(Integer ringBufferSizeInClosedState) {
            Objects.requireNonNull(ringBufferSizeInClosedState);
            if (ringBufferSizeInClosedState < 1) {
                throw new IllegalArgumentException("ringBufferSizeInClosedState must be greater than or equal to 1.");
            }
            this.ringBufferSizeInClosedState = ringBufferSizeInClosedState;
            return this;
        }

        @Nullable
        public Integer getRingBufferSizeInHalfOpenState() {
            return this.ringBufferSizeInHalfOpenState;
        }

        @Deprecated
        public InstanceProperties setRingBufferSizeInHalfOpenState(Integer ringBufferSizeInHalfOpenState) {
            Objects.requireNonNull(ringBufferSizeInHalfOpenState);
            if (ringBufferSizeInHalfOpenState < 1) {
                throw new IllegalArgumentException("ringBufferSizeInHalfOpenState must be greater than or equal to 1.");
            }
            this.ringBufferSizeInHalfOpenState = ringBufferSizeInHalfOpenState;
            return this;
        }

        public Boolean getAutomaticTransitionFromOpenToHalfOpenEnabled() {
            return this.automaticTransitionFromOpenToHalfOpenEnabled;
        }

        public InstanceProperties setAutomaticTransitionFromOpenToHalfOpenEnabled(Boolean automaticTransitionFromOpenToHalfOpenEnabled) {
            this.automaticTransitionFromOpenToHalfOpenEnabled = automaticTransitionFromOpenToHalfOpenEnabled;
            return this;
        }

        @Nullable
        public Boolean getWritableStackTraceEnabled() {
            return this.writableStackTraceEnabled;
        }

        public InstanceProperties setWritableStackTraceEnabled(Boolean writableStackTraceEnabled) {
            this.writableStackTraceEnabled = writableStackTraceEnabled;
            return this;
        }

        @Nullable
        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            Objects.requireNonNull(eventConsumerBufferSize);
            if (eventConsumerBufferSize < 1) {
                throw new IllegalArgumentException("eventConsumerBufferSize must be greater than or equal to 1.");
            }
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        @Nullable
        public Boolean getAllowHealthIndicatorToFail() {
            return this.allowHealthIndicatorToFail;
        }

        public InstanceProperties setAllowHealthIndicatorToFail(Boolean allowHealthIndicatorToFail) {
            this.allowHealthIndicatorToFail = allowHealthIndicatorToFail;
            return this;
        }

        @Nullable
        public Boolean getRegisterHealthIndicator() {
            return this.registerHealthIndicator;
        }

        public InstanceProperties setRegisterHealthIndicator(Boolean registerHealthIndicator) {
            this.registerHealthIndicator = registerHealthIndicator;
            return this;
        }

        @Nullable
        public Class<Predicate<Throwable>> getRecordFailurePredicate() {
            return this.recordFailurePredicate;
        }

        public InstanceProperties setRecordFailurePredicate(Class<Predicate<Throwable>> recordFailurePredicate) {
            this.recordFailurePredicate = recordFailurePredicate;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getRecordExceptions() {
            return this.recordExceptions;
        }

        public InstanceProperties setRecordExceptions(Class<? extends Throwable>[] recordExceptions) {
            this.recordExceptions = recordExceptions;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public InstanceProperties setIgnoreExceptions(Class<? extends Throwable>[] ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }

        @Nullable
        public Integer getPermittedNumberOfCallsInHalfOpenState() {
            return this.permittedNumberOfCallsInHalfOpenState;
        }

        public void setPermittedNumberOfCallsInHalfOpenState(Integer permittedNumberOfCallsInHalfOpenState) {
            Objects.requireNonNull(permittedNumberOfCallsInHalfOpenState);
            if (permittedNumberOfCallsInHalfOpenState < 1) {
                throw new IllegalArgumentException("permittedNumberOfCallsInHalfOpenState must be greater than or equal to 1.");
            }
            this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
        }

        @Nullable
        public Integer getMinimumNumberOfCalls() {
            return this.minimumNumberOfCalls;
        }

        public void setMinimumNumberOfCalls(Integer minimumNumberOfCalls) {
            Objects.requireNonNull(minimumNumberOfCalls);
            if (minimumNumberOfCalls < 1) {
                throw new IllegalArgumentException("minimumNumberOfCalls must be greater than or equal to 1.");
            }
            this.minimumNumberOfCalls = minimumNumberOfCalls;
        }

        @Nullable
        public Integer getSlidingWindowSize() {
            return this.slidingWindowSize;
        }

        public void setSlidingWindowSize(Integer slidingWindowSize) {
            Objects.requireNonNull(slidingWindowSize);
            if (slidingWindowSize < 1) {
                throw new IllegalArgumentException("slidingWindowSize must be greater than or equal to 1.");
            }
            this.slidingWindowSize = slidingWindowSize;
        }

        @Nullable
        public Float getSlowCallRateThreshold() {
            return this.slowCallRateThreshold;
        }

        public void setSlowCallRateThreshold(Float slowCallRateThreshold) {
            Objects.requireNonNull(slowCallRateThreshold);
            if (slowCallRateThreshold.floatValue() < 1.0f || slowCallRateThreshold.floatValue() > 100.0f) {
                throw new IllegalArgumentException("slowCallRateThreshold must be between 1 and 100.");
            }
            this.slowCallRateThreshold = slowCallRateThreshold;
        }

        @Nullable
        public Duration getSlowCallDurationThreshold() {
            return this.slowCallDurationThreshold;
        }

        public void setSlowCallDurationThreshold(Duration slowCallDurationThreshold) {
            Objects.requireNonNull(slowCallDurationThreshold);
            if (slowCallDurationThreshold.toNanos() < 1L) {
                throw new IllegalArgumentException("waitDurationInOpenStateMillis must be greater than or equal to 1 nanos.");
            }
            this.slowCallDurationThreshold = slowCallDurationThreshold;
        }

        @Nullable
        public CircuitBreakerConfig.SlidingWindowType getSlidingWindowType() {
            return this.slidingWindowType;
        }

        public void setSlidingWindowType(CircuitBreakerConfig.SlidingWindowType slidingWindowType) {
            this.slidingWindowType = slidingWindowType;
        }

        public Boolean getEnableExponentialBackoff() {
            return this.enableExponentialBackoff;
        }

        public InstanceProperties setEnableExponentialBackoff(Boolean enableExponentialBackoff) {
            this.enableExponentialBackoff = enableExponentialBackoff;
            return this;
        }

        @Nullable
        public Double getExponentialBackoffMultiplier() {
            return this.exponentialBackoffMultiplier;
        }

        public InstanceProperties setExponentialBackoffMultiplier(Double exponentialBackoffMultiplier) {
            this.exponentialBackoffMultiplier = exponentialBackoffMultiplier;
            return this;
        }

        @Nullable
        public Boolean getEnableRandomizedWait() {
            return this.enableRandomizedWait;
        }

        public InstanceProperties setEnableRandomizedWait(Boolean enableRandomizedWait) {
            this.enableRandomizedWait = enableRandomizedWait;
            return this;
        }

        @Nullable
        public Double getRandomizedWaitFactor() {
            return this.randomizedWaitFactor;
        }

        public InstanceProperties setRandomizedWaitFactor(Double randomizedWaitFactor) {
            this.randomizedWaitFactor = randomizedWaitFactor;
            return this;
        }
    }
}

