/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.discovery.consul;

import io.gravitee.discovery.api.ServiceDiscovery;
import io.gravitee.discovery.api.event.Event;
import io.gravitee.discovery.api.event.Handler;
import io.gravitee.discovery.api.service.AbstractServiceDiscovery;
import io.gravitee.discovery.consul.configuration.ConsulServiceDiscoveryConfiguration;
import io.gravitee.discovery.consul.configuration.KeyStoreType;
import io.gravitee.discovery.consul.configuration.TrustStoreType;
import io.gravitee.discovery.consul.service.ConsulService;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntry;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.Watch;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConsulServiceDiscovery
extends AbstractServiceDiscovery<ConsulService>
implements ServiceDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulServiceDiscovery.class);
    private static final String HTTPS_SCHEME = "https";
    private static final int CONSUL_DEFAULT_PORT = 8500;
    @Autowired
    private Vertx vertx;
    private final ConsulServiceDiscoveryConfiguration configuration;
    private Watch<ServiceEntryList> watcher;

    public ConsulServiceDiscovery(ConsulServiceDiscoveryConfiguration configuration) {
        this.configuration = configuration;
    }

    public void stop() throws Exception {
        if (this.watcher != null) {
            this.watcher.stop();
        }
    }

    public void listen(Handler<Event> handler) {
        URI consulUri = URI.create(this.configuration.getUrl());
        ConsulClientOptions options = new ConsulClientOptions().setHost(consulUri.getHost()).setPort(consulUri.getPort() != -1 ? consulUri.getPort() : 8500).setDc(this.configuration.getDc()).setAclToken(this.configuration.getAcl());
        if (HTTPS_SCHEME.equalsIgnoreCase(consulUri.getScheme())) {
            PfxOptions pfxOptions;
            JksOptions jksOptions;
            options.setSsl(true);
            if (this.configuration.getKeyStoreType() == null || this.configuration.getKeyStoreType() == KeyStoreType.NONE) {
                options.setTrustAll(true);
            } else if (this.configuration.getKeyStoreType() == KeyStoreType.JKS) {
                jksOptions = new JksOptions();
                jksOptions.setPassword(this.configuration.getKeyStorePassword());
                if (this.configuration.getKeyStoreContent() != null && this.configuration.getKeyStoreContent().isEmpty()) {
                    jksOptions.setValue(Buffer.buffer((String)this.configuration.getKeyStoreContent()));
                }
                jksOptions.setPath(this.configuration.getKeyStorePath());
                options.setKeyStoreOptions(jksOptions);
            } else if (this.configuration.getKeyStoreType() == KeyStoreType.PKCS12) {
                pfxOptions = new PfxOptions();
                pfxOptions.setPassword(this.configuration.getKeyStorePassword());
                if (this.configuration.getKeyStoreContent() != null && this.configuration.getKeyStoreContent().isEmpty()) {
                    pfxOptions.setValue(Buffer.buffer((String)this.configuration.getKeyStoreContent()));
                }
                pfxOptions.setPath(this.configuration.getKeyStorePath());
                options.setPfxKeyCertOptions(pfxOptions);
            }
            if (this.configuration.getTrustStoreType() == null || this.configuration.getTrustStoreType() == TrustStoreType.NONE) {
                options.setTrustAll(true);
            } else if (this.configuration.getTrustStoreType() == TrustStoreType.JKS) {
                jksOptions = new JksOptions();
                jksOptions.setPassword(this.configuration.getTrustStorePassword());
                jksOptions.setPath(this.configuration.getTrustStorePath());
                if (this.configuration.getTrustStoreContent() != null && this.configuration.getTrustStoreContent().isEmpty()) {
                    jksOptions.setValue(Buffer.buffer((String)this.configuration.getTrustStoreContent()));
                }
                options.setTrustStoreOptions(jksOptions);
            } else if (this.configuration.getTrustStoreType() == TrustStoreType.PKCS12) {
                pfxOptions = new PfxOptions();
                pfxOptions.setPassword(this.configuration.getTrustStorePassword());
                pfxOptions.setPath(this.configuration.getTrustStorePath());
                if (this.configuration.getTrustStoreContent() != null && !this.configuration.getTrustStoreContent().isEmpty()) {
                    pfxOptions.setValue(Buffer.buffer((String)this.configuration.getTrustStoreContent()));
                }
                options.setPfxTrustOptions(pfxOptions);
            }
        }
        LOGGER.info("Consul.io configuration: endpoint[{}] dc[{}] acl[{}]", new Object[]{consulUri.toString(), options.getDc(), options.getAclToken()});
        this.watcher = Watch.service((String)this.configuration.getService(), (Vertx)this.vertx, (ConsulClientOptions)options);
        this.watcher.setHandler(event -> {
            if (event.succeeded()) {
                List oldEntries;
                ConsulService consulService;
                LOGGER.debug("Receiving a Consul.io watch event for service: name[{}]", (Object)this.configuration.getService());
                List entries = ((ServiceEntryList)event.nextResult()).getList();
                for (ServiceEntry service : ((ServiceEntryList)event.nextResult()).getList()) {
                    Service service1 = service.getService();
                    service1.setNodeAddress(service.getNode().getAddress());
                    consulService = new ConsulService(service1);
                    ConsulService oldService = (ConsulService)this.getService(consulService::equals);
                    if (oldService == null) {
                        LOGGER.info("Register a new service from Consul.io: id[{}] name[{}]", (Object)service1.getId(), (Object)service1.getName());
                        handler.handle(this.registerEndpoint(consulService));
                        continue;
                    }
                    if (consulService.port() == oldService.port() && consulService.host().equals(oldService.host())) continue;
                    LOGGER.info("Update an existing service from Consul.io: id[{}] name[{}] address[{}:{}]", new Object[]{service1.getId(), service1.getName(), consulService.host(), consulService.port()});
                    handler.handle(this.unregisterEndpoint(oldService));
                    handler.handle(this.registerEndpoint(consulService));
                }
                if (event.prevResult() != null && (oldEntries = ((ServiceEntryList)event.prevResult()).getList()).size() > entries.size()) {
                    oldEntries.removeAll(entries);
                    for (ServiceEntry oldEntry : oldEntries) {
                        LOGGER.info("Remove a de-registered service from Consul.io: id[{}] name[{}]", (Object)oldEntry.getService().getId(), (Object)oldEntry.getService().getName());
                        consulService = new ConsulService(oldEntry.getService());
                        handler.handle(this.unregisterEndpoint(consulService));
                    }
                }
            } else {
                LOGGER.error("Unexpected error while watching services catalog", event.cause());
            }
        }).start();
    }
}

