/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.certificates;

import com.sun.nio.file.SensitivityWatchEventModifier;
import io.gravitee.common.util.KeyStoreUtils;
import io.gravitee.node.api.certificate.CertificateOptions;
import io.gravitee.node.api.certificate.KeyStoreBundle;
import io.gravitee.node.api.certificate.KeyStoreLoader;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileKeyStoreLoader
implements KeyStoreLoader {
    private static final Logger logger = LoggerFactory.getLogger(FileKeyStoreLoader.class);
    private final KeyStoreLoaderOptions options;
    private final List<Consumer<KeyStoreBundle>> listeners;
    private final ExecutorService executor;
    private KeyStoreBundle keyStoreBundle;
    private List<Path> filesToWatch;
    private boolean started;
    private boolean watching;

    public FileKeyStoreLoader(KeyStoreLoaderOptions options) {
        this.options = options;
        this.listeners = new ArrayList<Consumer<KeyStoreBundle>>();
        this.executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "gio.file-cert-watcher"));
        this.filesToWatch = new ArrayList<Path>();
    }

    public void start() {
        logger.debug("Initializing file keystore certificates.");
        this.load();
        this.started = true;
        if (this.options.isWatch()) {
            this.startWatch();
        }
    }

    public void stop() {
        this.started = false;
        this.executor.shutdown();
    }

    private void load() {
        if (this.options.getKeyStoreType().equalsIgnoreCase("JKS") || this.options.getKeyStoreType().equalsIgnoreCase("PKCS12")) {
            this.filesToWatch = this.loadFromKeyStore();
        } else if (this.options.getKeyStoreType().equalsIgnoreCase("PEM")) {
            this.filesToWatch = this.loadFromPems();
        } else if (this.options.getKeyStoreType().equalsIgnoreCase("SELF-SIGNED")) {
            this.filesToWatch = this.loadFromSelfSigned();
        } else {
            throw new IllegalArgumentException(String.format("Unsupported keystore format (%s).", this.options.getKeyStoreType()));
        }
        if (this.keyStoreBundle != null) {
            this.notifyListeners(this.keyStoreBundle);
        }
    }

    private List<Path> loadFromKeyStore() {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (this.options.getKeyStorePath() == null || this.options.getKeyStorePath().isEmpty()) {
            throw new IllegalArgumentException("A JKS/PKCS12 Keystore is missing. Unable to configure TLS.");
        }
        KeyStore keyStore = KeyStoreUtils.initFromPath((String)this.options.getKeyStoreType(), (String)this.options.getKeyStorePath(), (String)this.options.getKeyStorePassword());
        this.keyStoreBundle = new KeyStoreBundle(keyStore, this.options.getKeyStorePassword(), this.options.getDefaultAlias());
        paths.add(FileSystems.getDefault().getPath(this.options.getKeyStorePath(), new String[0]));
        return paths;
    }

    private List<Path> loadFromPems() {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (this.options.getKeyStoreCertificates() == null || this.options.getKeyStoreCertificates().isEmpty()) {
            throw new IllegalArgumentException("A PEM Keystore is missing. Unable to configure TLS.");
        }
        List<String> certs = this.options.getKeyStoreCertificates().stream().map(CertificateOptions::getCertificate).collect(Collectors.toList());
        List<String> keys = this.options.getKeyStoreCertificates().stream().map(CertificateOptions::getPrivateKey).collect(Collectors.toList());
        KeyStore keyStore = KeyStoreUtils.initFromPems(certs, keys, (String)this.options.getKeyStorePassword());
        this.keyStoreBundle = new KeyStoreBundle(keyStore, this.options.getKeyStorePassword(), null);
        certs.forEach(cert -> paths.add(FileSystems.getDefault().getPath((String)cert, new String[0])));
        keys.forEach(key -> paths.add(FileSystems.getDefault().getPath((String)key, new String[0])));
        return paths;
    }

    private List<Path> loadFromSelfSigned() {
        this.keyStoreBundle = null;
        return new ArrayList<Path>();
    }

    public void addListener(Consumer<KeyStoreBundle> listener) {
        this.listeners.add(listener);
    }

    private void startWatch() {
        this.executor.execute(() -> {
            try {
                WatchService watcherService = FileSystems.getDefault().newWatchService();
                List watchedPaths = this.filesToWatch.stream().map(Path::getParent).distinct().collect(Collectors.toList());
                for (Path path : watchedPaths) {
                    path.register(watcherService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
                }
                this.watching = true;
                while (this.started) {
                    WatchKey watchKey = watcherService.poll(200L, TimeUnit.MILLISECONDS);
                    if (watchKey == null) continue;
                    Optional<Path> optionalPath = watchKey.pollEvents().stream().map(watchEvent -> (Path)watchEvent.context()).filter(file -> this.filesToWatch.stream().map(Path::getFileName).anyMatch(file::equals)).findFirst();
                    if (optionalPath.isPresent()) {
                        this.load();
                    }
                    if (watchKey.reset()) continue;
                    break;
                }
            }
            catch (InterruptedException ie) {
                logger.info("Watch for keystore files has been stopped.");
            }
            catch (Exception e) {
                logger.error("Unable to watch the keystore files.", (Throwable)e);
            }
        });
    }

    private void notifyListeners(KeyStoreBundle keyStoreBundle) {
        this.listeners.forEach(consumer -> consumer.accept(keyStoreBundle));
    }

    public boolean isWatching() {
        return this.watching;
    }
}

