/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.certificates;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.certificate.KeyStoreLoader;
import io.gravitee.node.api.certificate.KeyStoreLoaderFactory;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.gravitee.node.certificates.FileKeyStoreLoaderFactory;
import io.gravitee.node.certificates.SelfSignedKeyStoreLoaderFactory;
import java.util.HashSet;
import java.util.Set;

public class KeyStoreLoaderManager
extends AbstractService<KeyStoreLoaderManager> {
    private final Set<KeyStoreLoaderFactory> loaderFactories = new HashSet<KeyStoreLoaderFactory>();
    private final Set<KeyStoreLoader> loaders = new HashSet<KeyStoreLoader>();

    public KeyStoreLoaderManager() {
        this.registerFactory(new FileKeyStoreLoaderFactory());
        this.registerFactory(new SelfSignedKeyStoreLoaderFactory());
    }

    public KeyStoreLoaderManager preStop() throws Exception {
        this.loaders.forEach(KeyStoreLoader::stop);
        return this;
    }

    public void registerFactory(KeyStoreLoaderFactory keyStoreLoaderFactory) {
        this.loaderFactories.add(keyStoreLoaderFactory);
    }

    public Set<KeyStoreLoaderFactory> getLoaderFactories() {
        return this.loaderFactories;
    }

    public KeyStoreLoader create(KeyStoreLoaderOptions options) {
        return this.getLoaderFactories().stream().filter(keyStoreLoaderFactory -> keyStoreLoaderFactory.canHandle(options)).findFirst().map(keyStoreLoaderFactory -> keyStoreLoaderFactory.create(options)).orElse(null);
    }
}

