/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.license;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.license.NodeLicenseService;
import io.gravitee.node.license.license3j.License3JLicense;
import io.gravitee.node.license.management.NodeLicenseManagementEndpoint;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.gravitee.node.management.http.endpoint.ManagementEndpointManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax0.license3j.License;
import javax0.license3j.io.LicenseReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class LicenseService
extends AbstractService<LicenseService> {
    private final Logger logger = LoggerFactory.getLogger(LicenseService.class);
    private static final String GRAVITEE_HOME_PROPERTY = "gravitee.home";
    private static final String GRAVITEE_LICENSE_PROPERTY = "gravitee.license";
    private static final String GRAVITEE_LICENSE_KEY = "license.key";
    private static final String LICENSE_EXPIRE_AT = "expiryDate";
    private static final long DAY_AS_LONG = 86400000L;
    @Autowired
    private ManagementEndpointManager managementEndpointManager;
    @Autowired
    private Node node;
    @Autowired
    private Environment environment;
    @Autowired
    private NodeLicenseService nodeLicenseService;
    private final byte[] key = new byte[]{82, 83, 65, 0, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -40, 89, -20, -74, 39, -14, 32, 47, 122, 57, -122, 43, 98, -74, -22, 91, -28, -128, -96, 50, 53, -77, -56, -43, 78, -73, -95, -2, 21, -124, -57, 117, 102, -113, 72, -15, -42, 48, 123, 57, -73, -41, 72, 79, -81, 56, -58, -71, -68, 60, -21, -19, -77, 3, -18, 27, -99, -123, -117, -4, -109, 86, 92, 9, -111, 65, 34, -25, 76, -10, -108, -99, -59, 113, 60, 45, -28, 76, 14, -43, 61, 111, -41, 32, 108, -40, -35, 18, 77, -22, 85, -35, 38, -93, 37, -29, -125, -100, -110, 21, -58, 69, -2, -102, 15, 71, -122, 69, 4, -74, 68, -4, 1, -122, 42, -10, -30, -3, 55, -15, -69, 112, -83, 21, -32, 124, -77, -108, -34, 47, -46, -60, 79, -53, -89, 49, -121, 102, -48, -9, 93, 9, -124, 75, -73, 75, -26, 28, -89, -39, -66, -98, -83, -25, 3, -52, -85, 4, 77, -33, -110, -114, -59, -95, 4, -48, 127, -119, 113, 45, 109, -113, -52, 30, 37, 94, 102, -65, -87, -8, -116, -17, -114, 106, -6, -50, -6, 121, -96, -34, 114, -53, -68, -112, -114, 41, 76, 64, 5, 97, 90, 68, 13, -57, 70, 101, -92, 42, -45, -86, -20, -125, 120, 82, 4, 43, -76, 21, -29, 102, -45, -75, -27, -25, 4, -73, -37, -4, 70, 50, -59, 113, -109, -35, -29, 7, -48, -51, -40, 14, -34, -63, -88, -90, 15, 69, -113, 6, 81, -2, 114, -73, 97, -54, 41, 103, 2, 3, 1, 0, 1};
    private LicenseReader reader;
    private License license;
    private Timer checkerTimer;
    private LicenseChecker checkerTask;
    private LicenseWatcher licenseWatcher;

    public io.gravitee.node.api.license.License getLicense() {
        return this.license == null ? null : new License3JLicense(this.license);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.loadLicense();
        this.startLicenseChecker();
        this.startLicenseWatcher();
        this.managementEndpointManager.register((ManagementEndpoint)new NodeLicenseManagementEndpoint(this.node));
    }

    private void startLicenseChecker() {
        this.checkerTimer = new Timer("gravitee-license-checker");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, 1);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.checkerTask = new LicenseChecker();
        this.checkerTimer.schedule((TimerTask)this.checkerTask, c.getTime(), 86400000L);
    }

    private void startLicenseWatcher() {
        String licenseKey = this.environment.getProperty(GRAVITEE_LICENSE_KEY);
        if (!StringUtils.hasLength((String)licenseKey)) {
            this.licenseWatcher = new LicenseWatcher(new File(this.getLicenseFile()));
            this.licenseWatcher.setName("gravitee-license-watcher");
            this.licenseWatcher.start();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.checkerTimer != null) {
            this.checkerTimer.cancel();
        }
        if (this.licenseWatcher != null) {
            this.licenseWatcher.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
    }

    protected String name() {
        return "License service";
    }

    public void loadLicense() throws Exception {
        byte[] licenseContent = this.getLicenseContent();
        if (licenseContent.length > 0) {
            try {
                this.reader = new LicenseReader((InputStream)new ByteArrayInputStream(licenseContent));
                this.license = this.reader.read();
                this.printLicenseInfo();
                this.verify();
                this.nodeLicenseService.refresh();
            }
            catch (IllegalArgumentException iae) {
                this.logger.error("License file is not valid", (Throwable)iae);
            }
            catch (IOException ioe) {
                this.logger.error("License file can not be read", (Throwable)ioe);
            }
        }
    }

    private byte[] getLicenseContent() {
        byte[] licenseContent;
        String licenseKey = this.environment.getProperty(GRAVITEE_LICENSE_KEY);
        if (StringUtils.hasLength((String)licenseKey)) {
            try {
                return Base64.getDecoder().decode(licenseKey);
            }
            catch (Exception ex) {
                this.logger.error("Can't decode the license key.", (Throwable)ex);
                return new byte[0];
            }
        }
        try {
            licenseContent = Files.readAllBytes(Paths.get(this.getLicenseFile(), new String[0]));
        }
        catch (IOException e) {
            this.logger.info("No license file found. Some plugins may be disabled");
            return new byte[0];
        }
        return licenseContent;
    }

    private String getLicenseFile() {
        Object licenseFile = System.getProperty(GRAVITEE_LICENSE_PROPERTY);
        if (licenseFile == null || ((String)licenseFile).isEmpty()) {
            licenseFile = System.getProperty(GRAVITEE_HOME_PROPERTY) + File.separator + "license" + File.separator + GRAVITEE_LICENSE_KEY;
        }
        return licenseFile;
    }

    private void verify() throws Exception {
        Date expiration;
        long remainingDays;
        if (this.license == null) {
            this.logger.debug("License will not be verified as it has not been loaded");
            return;
        }
        boolean valid = this.license.isOK(this.key);
        if (!valid) {
            this.logger.error("License is not valid. Please contact GraviteeSource to ask for a valid license.");
            this.stopNode();
        }
        if (this.license.isExpired()) {
            this.logger.error("License is expired. Please contact GraviteeSource to ask for a renewed license.");
            this.stopNode();
        }
        if ((remainingDays = Math.round((double)((expiration = this.license.get(LICENSE_EXPIRE_AT).getDate()).getTime() - System.currentTimeMillis()) / 8.64E7)) <= 30L) {
            this.logger.warn("License will be no longer valid in {} days. Please contact GraviteeSource to renew it.", (Object)remainingDays);
        }
    }

    private void printLicenseInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("License information: \n");
        this.license.getFeatures().forEach((name, feature) -> sb.append("\t").append((String)name).append(": ").append(feature.valueString()).append("\n"));
        this.logger.info(sb.toString());
    }

    private void stopNode() throws Exception {
        this.node.stop();
        System.exit(0);
    }

    private class LicenseChecker
    extends TimerTask {
        private LicenseChecker() {
        }

        @Override
        public void run() {
            try {
                LicenseService.this.verify();
            }
            catch (Exception e) {
                LicenseService.this.logger.error("An error occurred while checking license", (Throwable)e);
            }
        }
    }

    private class LicenseWatcher
    extends Thread {
        private final File file;
        private final AtomicBoolean stop = new AtomicBoolean(false);

        LicenseWatcher(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            LicenseService.this.logger.debug("Watching license for next changes: {}", (Object)this.file.getAbsolutePath());
            try (WatchService watcher = FileSystems.getDefault().newWatchService();){
                Path path = this.file.toPath().getParent();
                path.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
                while (!this.stop.get()) {
                    WatchKey watchKey;
                    try {
                        watchKey = watcher.poll(25L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        if (watcher != null) {
                            watcher.close();
                        }
                        return;
                    }
                    if (watchKey == null) {
                        Thread.yield();
                        continue;
                    }
                    for (WatchEvent<?> event : watchKey.pollEvents()) {
                        boolean valid;
                        WatchEvent.Kind<?> kind = event.kind();
                        WatchEvent<?> ev = event;
                        Path filename = (Path)ev.context();
                        if (kind == StandardWatchEventKinds.OVERFLOW) {
                            Thread.yield();
                            continue;
                        }
                        if (kind == StandardWatchEventKinds.ENTRY_MODIFY && filename.toString().equals(this.file.getName())) {
                            LicenseService.this.loadLicense();
                        }
                        if (valid = watchKey.reset()) continue;
                        break;
                    }
                    Thread.yield();
                }
            }
            catch (Exception e) {
                LicenseService.this.logger.debug("An error occurred while watching license file", (Throwable)e);
            }
        }

        void close() {
            this.stop.set(true);
        }
    }
}

