/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http.metrics.prometheus;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.micrometer.backends.BackendRegistries;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusEndpoint
implements ManagementEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusEndpoint.class);

    @Override
    public HttpMethod method() {
        return HttpMethod.GET;
    }

    @Override
    public String path() {
        return "/metrics/prometheus";
    }

    @Override
    public void handle(RoutingContext routingContext) {
        PrometheusMeterRegistry registry = (PrometheusMeterRegistry)BackendRegistries.getDefaultNow();
        HttpServerResponse response = routingContext.response();
        response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; version=0.0.4; charset=utf-8");
        response.setChunked(true);
        try (BufferWriter writer = new BufferWriter(response);){
            registry.scrape((Writer)writer);
        }
        catch (IOException ioe) {
            LOGGER.error("Unexpected error while scraping the Prometheus endpoint", (Throwable)ioe);
            response.close();
        }
    }

    private static byte[] charArrayToByteArray(char[] charBuf) {
        if (charBuf == null) {
            return null;
        }
        int iLen = charBuf.length;
        byte[] buf = new byte[iLen];
        for (int p = 0; p < iLen; ++p) {
            buf[p] = (byte)charBuf[p];
        }
        return buf;
    }

    private static class BufferWriter
    extends Writer {
        private final HttpServerResponse response;

        private BufferWriter(HttpServerResponse response) {
            this.response = response;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.push(Buffer.buffer((byte[])PrometheusEndpoint.charArrayToByteArray(cbuf)));
        }

        @Override
        public void write(int c) throws IOException {
            this.push(Buffer.buffer((int)1).appendByte((byte)(c & 0xFF)));
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.push(Buffer.buffer((String)new String(cbuf)));
        }

        @Override
        public void write(String str) throws IOException {
            this.push(Buffer.buffer((String)str));
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.push(Buffer.buffer((String)str));
        }

        private void push(Buffer buffer) {
            this.response.write((Object)buffer);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws IOException {
            this.response.end();
        }
    }
}

