/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http.node.thread;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.gravitee.node.management.http.node.thread.PlainTextThreadDumpFormatter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumpEndpoint
implements ManagementEndpoint {
    private final Logger LOGGER = LoggerFactory.getLogger(ThreadDumpEndpoint.class);
    private final PlainTextThreadDumpFormatter plainTextFormatter = new PlainTextThreadDumpFormatter();

    @Override
    public HttpMethod method() {
        return HttpMethod.GET;
    }

    @Override
    public String path() {
        return "/threaddump";
    }

    @Override
    public void handle(final RoutingContext context) {
        context.vertx().executeBlocking((Handler)new Handler<Promise<String>>(){

            public void handle(Promise<String> promise) {
                try {
                    ThreadInfo[] threadInfos = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
                    String dump = ThreadDumpEndpoint.this.plainTextFormatter.format(threadInfos);
                    promise.complete((Object)dump);
                }
                catch (Exception ex) {
                    promise.fail((Throwable)ex);
                }
            }
        }, (Handler)new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> threadDumpResult) {
                if (threadDumpResult.succeeded()) {
                    context.response().setStatusCode(200).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain;charset=UTF-8").setChunked(true).send((String)threadDumpResult.result());
                } else {
                    ThreadDumpEndpoint.this.LOGGER.error("Unable to generate thread dump.", threadDumpResult.cause());
                    context.response().setStatusCode(500).setChunked(true).send(threadDumpResult.cause().getMessage());
                }
            }
        });
    }
}

