/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http.vertx.spring;

import io.gravitee.node.management.http.vertx.auth.BasicAuthProvider;
import io.gravitee.node.management.http.vertx.configuration.HttpServerConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.Router;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class HttpServerSpringConfiguration {
    private static final String CERTIFICATE_FORMAT_JKS = "JKS";
    private static final String CERTIFICATE_FORMAT_PEM = "PEM";
    private static final String CERTIFICATE_FORMAT_PKCS12 = "PKCS12";

    @Bean(value={"managementRouter"})
    public Router router(Vertx vertx) {
        return Router.router((Vertx)vertx);
    }

    @Bean(value={"managementWebhookRouter"})
    public Router webHookRouter(Vertx vertx) {
        return Router.router((Vertx)vertx);
    }

    @Bean(value={"managementHttpServer"})
    public HttpServer httpServer(Vertx vertx) {
        HttpServerOptions options = new HttpServerOptions().setPort(this.httpServerConfiguration().getPort()).setHost(this.httpServerConfiguration().getHost());
        if (this.httpServerConfiguration().isSecured()) {
            options.setSsl(this.httpServerConfiguration().isSecured());
            options.setUseAlpn(this.httpServerConfiguration().isAlpn());
            String clientAuth = this.httpServerConfiguration().getClientAuth();
            if (!StringUtils.isEmpty((Object)clientAuth)) {
                if (clientAuth.equalsIgnoreCase(Boolean.TRUE.toString())) {
                    options.setClientAuth(ClientAuth.REQUIRED);
                } else {
                    options.setClientAuth(ClientAuth.NONE);
                }
            } else {
                options.setClientAuth(ClientAuth.REQUEST);
            }
            if (this.httpServerConfiguration().getTrustStorePath() != null) {
                if (this.httpServerConfiguration().getTrustStoreType() == null || this.httpServerConfiguration().getTrustStoreType().isEmpty() || this.httpServerConfiguration().getTrustStoreType().equalsIgnoreCase(CERTIFICATE_FORMAT_JKS)) {
                    options.setTrustStoreOptions(new JksOptions().setPath(this.httpServerConfiguration().getTrustStorePath()).setPassword(this.httpServerConfiguration().getTrustStorePassword()));
                } else if (this.httpServerConfiguration().getTrustStoreType().equalsIgnoreCase(CERTIFICATE_FORMAT_PEM)) {
                    options.setPemTrustOptions(new PemTrustOptions().addCertPath(this.httpServerConfiguration().getTrustStorePath()));
                } else if (this.httpServerConfiguration().getTrustStoreType().equalsIgnoreCase(CERTIFICATE_FORMAT_PKCS12)) {
                    options.setPfxTrustOptions(new PfxOptions().setPath(this.httpServerConfiguration().getTrustStorePath()).setPassword(this.httpServerConfiguration().getTrustStorePassword()));
                }
            }
            if (this.httpServerConfiguration().getKeyStorePath() != null) {
                if (this.httpServerConfiguration().getKeyStoreType() == null || this.httpServerConfiguration().getKeyStoreType().isEmpty() || this.httpServerConfiguration().getKeyStoreType().equalsIgnoreCase(CERTIFICATE_FORMAT_JKS)) {
                    options.setKeyStoreOptions(new JksOptions().setPath(this.httpServerConfiguration().getKeyStorePath()).setPassword(this.httpServerConfiguration().getKeyStorePassword()));
                } else if (this.httpServerConfiguration().getKeyStoreType().equalsIgnoreCase(CERTIFICATE_FORMAT_PEM)) {
                    options.setPemKeyCertOptions(new PemKeyCertOptions().addCertPath(this.httpServerConfiguration().getKeyStorePath()));
                } else if (this.httpServerConfiguration().getKeyStoreType().equalsIgnoreCase(CERTIFICATE_FORMAT_PKCS12)) {
                    options.setPfxKeyCertOptions(new PfxOptions().setPath(this.httpServerConfiguration().getKeyStorePath()).setPassword(this.httpServerConfiguration().getKeyStorePassword()));
                }
            }
        }
        options.setIdleTimeout(this.httpServerConfiguration().getIdleTimeout());
        return vertx.createHttpServer(options);
    }

    @Bean(value={"managementAuthProvider"})
    public AuthProvider authProvider() {
        return new BasicAuthProvider();
    }

    @Bean(value={"managementHttpServerConfiguration"})
    public HttpServerConfiguration httpServerConfiguration() {
        return new HttpServerConfiguration();
    }
}

