/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.services.initializer;

import io.gravitee.common.component.LifecycleComponent;
import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.initializer.Initializer;
import java.util.Comparator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializerServiceImpl
extends AbstractService<InitializerServiceImpl>
implements LifecycleComponent<InitializerServiceImpl> {
    private static final Logger logger = LoggerFactory.getLogger(InitializerServiceImpl.class);

    protected String name() {
        return "Initializer service";
    }

    protected void doStart() throws Exception {
        super.doStart();
        Map initializerBeans = this.applicationContext.getBeansOfType(Initializer.class);
        initializerBeans.values().stream().sorted(Comparator.comparing(Initializer::getOrder)).forEach(initializer -> {
            try {
                logger.info("Apply {} ...", (Object)initializer.getClass().getSimpleName());
                initializer.initialize();
            }
            catch (Exception e) {
                logger.error("Unable to apply the initializer {}", (Object)initializer.getClass().getSimpleName());
            }
        });
    }
}

