/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.notifier.api;

import io.gravitee.notifier.api.Notification;
import io.gravitee.notifier.api.Notifier;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNotifier
implements Notifier {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String type;

    AbstractNotifier(String type) {
        this.type = type;
    }

    private boolean canHandle(Notification notification) {
        return this.type.equals(notification.getType());
    }

    @Override
    public CompletableFuture<Void> send(Notification notification, Map<String, Object> parameters) {
        if (this.canHandle(notification)) {
            return this.doSend(notification, parameters);
        }
        return CompletableFuture.completedFuture(null);
    }

    private String getType() {
        return this.type;
    }

    public String name() {
        return null;
    }

    protected abstract CompletableFuture<Void> doSend(Notification var1, Map<String, Object> var2);
}

