/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.notifier.api;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.gravitee.notifier.api.Period;
import io.gravitee.notifier.api.jackson.RawJsonDeserializer;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;

public class Notification
implements Serializable {
    private String type;
    private List<Period> periods;
    @JsonDeserialize(using=RawJsonDeserializer.class)
    @JsonRawValue
    private String configuration;

    public boolean canNotify(long timestamp) {
        List<Period> periods = this.getPeriods();
        if (periods == null || periods.isEmpty()) {
            return true;
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC);
        return periods.stream().anyMatch(period -> period.isIncluded(localDateTime));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public List<Period> getPeriods() {
        return this.periods;
    }

    public void setPeriods(List<Period> periods) {
        this.periods = periods;
    }
}

