/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.notifier.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;

public class Period
implements Serializable {
    private static final String DEFAULT_ZONE_ID = ZoneId.systemDefault().getId();
    private static final int DEFAULT_BEGIN_HOUR = 0;
    private static final int DEFAULT_END_HOURS = 86399;
    private List<Integer> days;
    private String zoneId;
    private int beginHour;
    private int endHour;

    @JsonCreator
    protected Period(@JsonProperty(value="days") List<Integer> days, @JsonProperty(value="zoneId", required=true) String zoneId, @JsonProperty(value="beginHour", required=true) Integer beginHour, @JsonProperty(value="endHour", required=true) Integer endHour) {
        this.days = days;
        this.zoneId = zoneId;
        this.beginHour = beginHour == null ? 0 : beginHour;
        this.endHour = endHour == null ? 86399 : endHour;
    }

    public boolean isIncluded(LocalDateTime dateTime) {
        ZoneId zoneId = ZoneId.of(this.getZoneId());
        ZonedDateTime zonedDateTime = dateTime.atZone(ZoneOffset.systemDefault()).withZoneSameInstant(zoneId);
        if (this.days != null && !this.days.contains(zonedDateTime.getDayOfWeek().getValue())) {
            return false;
        }
        OffsetTime time = zonedDateTime.toOffsetDateTime().toOffsetTime();
        OffsetTime begin = OffsetTime.of(LocalTime.ofSecondOfDay(this.beginHour), zoneId.getRules().getOffset(Instant.now()));
        OffsetTime end = OffsetTime.of(LocalTime.ofSecondOfDay(this.endHour), zoneId.getRules().getOffset(Instant.now()));
        return this.isBetween(time, begin, end);
    }

    private boolean isBetween(OffsetTime time, OffsetTime begin, OffsetTime end) {
        return time.isEqual(begin) || time.isAfter(begin) && (time.isBefore(end) || time.isEqual(end));
    }

    public List<Integer> getDays() {
        return this.days;
    }

    public void setDays(List<Integer> days) {
        this.days = days;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public int getBeginHour() {
        return this.beginHour;
    }

    public void setBeginHour(int beginHour) {
        this.beginHour = beginHour;
    }

    public int getEndHour() {
        return this.endHour;
    }

    public void setEndHour(int endHour) {
        this.endHour = endHour;
    }

    public String toString() {
        return "Period{days=" + this.days + ", zoneId='" + this.zoneId + "', beginHour=" + this.beginHour + ", endHour=" + this.endHour + "}";
    }

    public static class Builder {
        private List<Integer> days;
        private String zoneId = DEFAULT_ZONE_ID;
        private int beginHour = 0;
        private int endHour = 86399;

        public Builder days(List<Integer> days) {
            this.days = days;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder beginHour(int beginHour) {
            this.beginHour = beginHour;
            return this;
        }

        public Builder endHour(int endHour) {
            this.endHour = endHour;
            return this;
        }

        public Period build() {
            return new Period(this.days, this.zoneId, this.beginHour, this.endHour);
        }
    }
}

