/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.component;

public class Lifecycle {
    private volatile State state = State.INITIALIZED;

    public State state() {
        return this.state;
    }

    public boolean initialized() {
        return this.state == State.INITIALIZED;
    }

    public boolean started() {
        return this.state == State.STARTED;
    }

    public boolean stopped() {
        return this.state == State.STOPPED;
    }

    public boolean closed() {
        return this.state == State.CLOSED;
    }

    public boolean moveToStarted() {
        State localState = this.state;
        if (localState == State.INITIALIZED || localState == State.STOPPED) {
            this.state = State.STARTED;
            return true;
        }
        if (localState == State.STARTED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to started state when closed");
        }
        throw new IllegalStateException("Can't move to started with unknown state");
    }

    public boolean moveToStopping() {
        this.state = State.STOPPING;
        return true;
    }

    public boolean moveToStopped() {
        State localState = this.state;
        if (localState == State.STARTED || localState == State.STOPPING) {
            this.state = State.STOPPED;
            return true;
        }
        if (localState == State.INITIALIZED || localState == State.STOPPED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to stopped state when closed");
        }
        throw new IllegalStateException("Can't move to stopped with unknown state");
    }

    public String toString() {
        return this.state.toString();
    }

    public static enum State {
        INITIALIZED,
        STOPPED,
        STOPPING,
        STARTED,
        CLOSED;

    }
}

