/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemReader;

public class KeyStoreUtils {
    public static final String TYPE_JKS = "JKS";
    public static final String TYPE_PEM = "PEM";
    public static final String TYPE_PKCS12 = "PKCS12";
    public static final String DEFAULT_ALIAS = "dummy-entry";
    public static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";
    private static final int DNSNAME = 2;
    private static final Date DEFAULT_NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    private static final Date DEFAULT_NOT_AFTER = new Date(253402300799000L);
    private static final int DEFAULT_KEY_LENGTH_BITS = 2048;
    private static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA256WithRSAEncryption";
    private static final String DEFAULT_ALGORITHM = "RSA";

    public static KeyStore initFromPath(String format, String path, String password) {
        KeyStore keyStore;
        block8: {
            InputStream is = new File(path).toURI().toURL().openStream();
            try {
                KeyStore keyStore2 = KeyStore.getInstance(format);
                keyStore2.load(is, KeyStoreUtils.passwordToCharArray(password));
                keyStore = keyStore2;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Unable to load keystore from path [%s]", path), e);
                }
            }
            is.close();
        }
        return keyStore;
    }

    public static KeyStore initFromContent(String format, String keystore, String password) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(Base64.getDecoder().decode(keystore));
            KeyStore keyStore = KeyStore.getInstance(format);
            keyStore.load(stream, KeyStoreUtils.passwordToCharArray(password));
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to get keystore from base64", e);
        }
    }

    public static KeyStore initSelfSigned(String fqdn, String password) {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(null, new char[0]);
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(DEFAULT_ALGORITHM);
            SecureRandom random = new SecureRandom();
            keyGen.initialize(2048, random);
            KeyPair keypair = keyGen.generateKeyPair();
            PrivateKey privateKey = keypair.getPrivate();
            X500Name cn = new X500Name("CN=" + fqdn);
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(cn, new BigInteger(64, random), DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, cn, keypair.getPublic());
            ContentSigner signer = new JcaContentSignerBuilder(DEFAULT_SIGNATURE_ALGORITHM).build(privateKey);
            X509CertificateHolder certHolder = builder.build(signer);
            JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider());
            X509Certificate certificate = converter.getCertificate(certHolder);
            certificate.verify(keypair.getPublic());
            keyStore.setEntry(DEFAULT_ALIAS, new KeyStore.PrivateKeyEntry(privateKey, new Certificate[]{certificate}), new KeyStore.PasswordProtection(KeyStoreUtils.passwordToCharArray(password)));
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to get keystore from base64", e);
        }
    }

    public static KeyStore initFromPems(List<String> pemPathCertificates, List<String> pemPathPrivateKeys, String password) {
        if (pemPathCertificates.size() != pemPathPrivateKeys.size()) {
            throw new IllegalArgumentException(String.format("Mismatch between number of certificates (%s) and number of private keys (%s)", pemPathCertificates.size(), pemPathPrivateKeys.size()));
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            char[] charPassword = KeyStoreUtils.passwordToCharArray(password);
            keyStore.load(null, charPassword);
            for (int i = 0; i < pemPathCertificates.size(); ++i) {
                try (InputStream certIs = new File(pemPathCertificates.get(i)).toURI().toURL().openStream();
                     InputStream keyIs = new File(pemPathPrivateKeys.get(i)).toURI().toURL().openStream();){
                    Certificate[] certificates = KeyStoreUtils.loadPemCertificates(new String(certIs.readAllBytes()));
                    PrivateKey privateKey = KeyStoreUtils.loadPemPrivateKey(new String(keyIs.readAllBytes()));
                    keyStore.setEntry("dummy-entry-" + i, new KeyStore.PrivateKeyEntry(privateKey, certificates), new KeyStore.PasswordProtection(charPassword));
                    continue;
                }
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to initialize keystore from pem certificate and private key", e);
        }
    }

    public static KeyStore initFromPem(String pemCertificate, String pemPrivateKey, String password, String alias) {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            Certificate[] certificates = KeyStoreUtils.loadPemCertificates(pemCertificate);
            PrivateKey privateKey = KeyStoreUtils.loadPemPrivateKey(pemPrivateKey);
            keyStore.load(null, KeyStoreUtils.passwordToCharArray(password));
            keyStore.setEntry(alias == null ? DEFAULT_ALIAS : alias, new KeyStore.PrivateKeyEntry(privateKey, certificates), new KeyStore.PasswordProtection(KeyStoreUtils.passwordToCharArray(password)));
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to initialize keystore from pem certificate and private key", e);
        }
    }

    public static Certificate[] loadPemCertificates(String pem) throws Exception {
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider());
        PemReader pemReader = new PemReader((Reader)new StringReader(pem));
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        try (PEMParser pemParser = new PEMParser((Reader)pemReader);){
            Object o;
            while ((o = pemParser.readObject()) != null) {
                X509Certificate certificate;
                if (!(o instanceof X509CertificateHolder) || (certificate = converter.getCertificate((X509CertificateHolder)o)) == null) continue;
                certificates.add(certificate);
            }
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    public static PrivateKey loadPemPrivateKey(String pem) throws IOException {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        PemReader pemReader = new PemReader((Reader)new StringReader(pem));
        try (PEMParser pemParser = new PEMParser((Reader)pemReader);){
            Object o;
            while ((o = pemParser.readObject()) != null) {
                PrivateKey privateKey;
                if (o instanceof PEMKeyPair) {
                    privateKey = converter.getPrivateKey(((PEMKeyPair)o).getPrivateKeyInfo());
                    if (privateKey == null) continue;
                    PrivateKey privateKey2 = privateKey;
                    return privateKey2;
                }
                if (!(o instanceof PrivateKeyInfo) || (privateKey = converter.getPrivateKey((PrivateKeyInfo)o)) == null) continue;
                PrivateKey privateKey3 = privateKey;
                return privateKey3;
            }
            throw new IllegalArgumentException("No private key found for the specified pem content.");
        }
    }

    public static char[] passwordToCharArray(String password) {
        return password != null ? password.toCharArray() : new char[]{};
    }

    public static String getDefaultAlias(KeyStore keyStore) {
        try {
            if (keyStore.aliases().hasMoreElements()) {
                return keyStore.aliases().nextElement();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to get default alias from keystore.", e);
        }
        return null;
    }

    public static KeyStore merge(KeyStore source1, KeyStore source2, String password) {
        return KeyStoreUtils.merge(Arrays.asList(source1, source2), password);
    }

    public static KeyStore merge(List<KeyStore> sources, String password) {
        try {
            KeyStore destination = KeyStore.getInstance("PKCS12");
            destination.load(null, KeyStoreUtils.passwordToCharArray(password));
            sources.forEach(source -> KeyStoreUtils.copy(source, destination, password));
            return destination;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to merge the 2 keystores", e);
        }
    }

    public static void copy(KeyStore source, KeyStore destination, String password) {
        try {
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(KeyStoreUtils.passwordToCharArray(password));
            Enumeration<String> aliases = source.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                KeyStore.Entry entry = source.getEntry(alias, passwordProtection);
                if (destination.containsAlias(alias)) {
                    throw new IllegalArgumentException(String.format("The alias [%s] is present in both keystores. Aliases must be unique.", alias));
                }
                destination.setEntry(alias, entry, passwordProtection);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to copy source keystore into destination keystore", e);
        }
    }

    public static Map<String, String> getCommonNamesByAlias(KeyStore keyStore) {
        try {
            HashMap<String, String> names = new HashMap<String, String>();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Collection<List<?>> altNames;
                String alias = aliases.nextElement();
                Certificate certificate = keyStore.getCertificate(alias);
                if (!(certificate instanceof X509Certificate)) continue;
                X509Certificate x509Certificate = (X509Certificate)certificate;
                X500Name x500name = new JcaX509CertificateHolder(x509Certificate).getSubject();
                RDN[] rdNs = x500name.getRDNs(BCStyle.CN);
                if (rdNs.length > 0) {
                    names.put(IETFUtils.valueToString((ASN1Encodable)rdNs[0].getFirst().getValue()), alias);
                }
                if ((altNames = x509Certificate.getSubjectAlternativeNames()) == null) continue;
                altNames.stream().filter(entry -> (Integer)entry.get(0) == 2).forEach(entry -> names.put(entry.get(1).toString(), alias));
            }
            return names;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to extract CN/SAN from keystore.", e);
        }
    }
}

