/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.utils;

import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleTransformer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;

public class RxHelper {
    public static <R> FlowableTransformer<R, R> mergeWithFirst(Flowable<R> other) {
        return upstream -> other.materialize().mergeWith((Publisher)upstream.materialize()).dematerialize(n -> n);
    }

    public static <R> FlowableTransformer<R, R> delayElement(int delay, TimeUnit timeUnit) {
        return upstream -> upstream.concatMapSingle(e -> Single.just((Object)e).delay((long)delay, timeUnit));
    }

    public static <R> FlowableTransformer<R, R> retryFlowable(int times, int retryInterval, TimeUnit timeUnit) {
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit)).compose(RxHelper.takeThenThrow(times)));
    }

    public static <R> MaybeTransformer<R, R> retryMaybe(int times, int retryInterval, TimeUnit timeUnit) {
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit)).compose(RxHelper.takeThenThrow(times)));
    }

    public static <R> SingleTransformer<R, R> retrySingle(int times, int retryInterval, TimeUnit timeUnit) {
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit)).compose(RxHelper.takeThenThrow(times)));
    }

    public static CompletableTransformer retry(int times, int retryInterval, TimeUnit timeUnit) {
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit)).compose(RxHelper.takeThenThrow(times)));
    }

    private static <R extends Throwable> FlowableTransformer<R, R> takeThenThrow(int limit) {
        AtomicInteger tries = new AtomicInteger(0);
        return upstream -> upstream.flatMapMaybe(throwable -> {
            if (tries.incrementAndGet() > limit) {
                return Maybe.error((Throwable)throwable);
            }
            return Maybe.just((Object)throwable);
        });
    }

    private RxHelper() {
    }
}

