/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mail.CanonicalizationAlgorithm;
import io.vertx.ext.mail.DKIMSignAlgorithm;
import io.vertx.ext.mail.DKIMSignOptionsConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class DKIMSignOptions {
    private static final List<String> DEFAULT_HEADERS = new ArrayList<String>();
    private String privateKey;
    private String privateKeyPath;
    private DKIMSignAlgorithm signAlgo = DKIMSignAlgorithm.RSA_SHA256;
    private List<String> signedHeaders;
    private String sdid;
    private String auid;
    private String selector;
    private CanonicalizationAlgorithm headerCanonAlgo = CanonicalizationAlgorithm.SIMPLE;
    private CanonicalizationAlgorithm bodyCanonAlgo = CanonicalizationAlgorithm.SIMPLE;
    private int bodyLimit = -1;
    private boolean signatureTimestamp;
    private long expireTime = -1L;
    private List<String> copiedHeaders;

    public DKIMSignOptions() {
        this.signedHeaders = new ArrayList<String>(DEFAULT_HEADERS);
    }

    public DKIMSignOptions(DKIMSignOptions other) {
        this.privateKey = other.privateKey;
        this.privateKeyPath = other.privateKeyPath;
        this.signAlgo = other.signAlgo;
        this.signedHeaders = other.signedHeaders != null && !other.signedHeaders.isEmpty() ? new ArrayList<String>(other.signedHeaders) : new ArrayList<String>(DEFAULT_HEADERS);
        this.sdid = other.sdid;
        this.auid = other.auid;
        this.selector = other.selector;
        this.headerCanonAlgo = other.headerCanonAlgo;
        this.bodyCanonAlgo = other.bodyCanonAlgo;
        this.bodyLimit = other.bodyLimit;
        this.signatureTimestamp = other.signatureTimestamp;
        this.expireTime = other.expireTime;
        if (other.copiedHeaders != null && !other.copiedHeaders.isEmpty()) {
            this.copiedHeaders = new ArrayList<String>(other.copiedHeaders);
        }
    }

    public DKIMSignOptions(JsonObject config) {
        DKIMSignOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)config, this);
        if (this.signedHeaders == null || this.signedHeaders.isEmpty()) {
            this.signedHeaders = new ArrayList<String>(DEFAULT_HEADERS);
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        DKIMSignOptionsConverter.toJson(this, json);
        return json;
    }

    public DKIMSignAlgorithm getSignAlgo() {
        return this.signAlgo;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public DKIMSignOptions setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public DKIMSignOptions setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
        return this;
    }

    public DKIMSignOptions setSignAlgo(DKIMSignAlgorithm signAlgo) {
        this.signAlgo = signAlgo;
        return this;
    }

    public List<String> getSignedHeaders() {
        return this.signedHeaders;
    }

    public DKIMSignOptions setSignedHeaders(List<String> signedHeaders) {
        this.signedHeaders = signedHeaders;
        return this;
    }

    public DKIMSignOptions addSignedHeader(String header) {
        if (this.signedHeaders == null) {
            this.signedHeaders = new ArrayList<String>();
        }
        this.signedHeaders.add(header);
        return this;
    }

    public String getSdid() {
        return this.sdid;
    }

    public DKIMSignOptions setSdid(String sdid) {
        this.sdid = sdid;
        return this;
    }

    public String getSelector() {
        return this.selector;
    }

    public DKIMSignOptions setSelector(String selector) {
        this.selector = selector;
        return this;
    }

    public CanonicalizationAlgorithm getHeaderCanonAlgo() {
        return this.headerCanonAlgo;
    }

    public DKIMSignOptions setHeaderCanonAlgo(CanonicalizationAlgorithm headerCanonAlgo) {
        this.headerCanonAlgo = headerCanonAlgo;
        return this;
    }

    public CanonicalizationAlgorithm getBodyCanonAlgo() {
        return this.bodyCanonAlgo;
    }

    public DKIMSignOptions setBodyCanonAlgo(CanonicalizationAlgorithm bodyCanonAlgo) {
        this.bodyCanonAlgo = bodyCanonAlgo;
        return this;
    }

    public String getAuid() {
        return this.auid;
    }

    public DKIMSignOptions setAuid(String auid) {
        this.auid = auid;
        return this;
    }

    public int getBodyLimit() {
        return this.bodyLimit;
    }

    public DKIMSignOptions setBodyLimit(int bodyLimit) {
        if (bodyLimit <= 0) {
            throw new IllegalArgumentException("Body Limit to calculate the hash must be larger than 0");
        }
        this.bodyLimit = bodyLimit;
        return this;
    }

    public boolean isSignatureTimestamp() {
        return this.signatureTimestamp;
    }

    public DKIMSignOptions setSignatureTimestamp(boolean signatureTimestamp) {
        this.signatureTimestamp = signatureTimestamp;
        return this;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public DKIMSignOptions setExpireTime(long expireTime) {
        if (expireTime <= 0L) {
            throw new IllegalArgumentException("Expire time must be larger than 0");
        }
        this.expireTime = expireTime;
        return this;
    }

    public List<String> getCopiedHeaders() {
        return this.copiedHeaders;
    }

    public DKIMSignOptions setCopiedHeaders(List<String> copiedHeaders) {
        this.copiedHeaders = copiedHeaders;
        return this;
    }

    public DKIMSignOptions addCopiedHeader(String header) {
        if (this.copiedHeaders == null) {
            this.copiedHeaders = new ArrayList<String>();
        }
        if (!this.copiedHeaders.contains(header)) {
            this.copiedHeaders.add(header);
        }
        return this;
    }

    private List<Object> getList() {
        return Arrays.asList(new Object[]{this.privateKey, this.privateKeyPath, this.signAlgo, this.signedHeaders, this.sdid, this.selector, this.headerCanonAlgo, this.bodyCanonAlgo, this.auid, this.bodyLimit, this.signatureTimestamp, this.expireTime, this.copiedHeaders});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DKIMSignOptions)) {
            return false;
        }
        DKIMSignOptions ops = (DKIMSignOptions)o;
        return this.getList().equals(ops.getList());
    }

    public int hashCode() {
        return this.getList().hashCode();
    }

    static {
        DEFAULT_HEADERS.add("From");
        DEFAULT_HEADERS.add("Reply-to");
        DEFAULT_HEADERS.add("Subject");
        DEFAULT_HEADERS.add("Date");
        DEFAULT_HEADERS.add("To");
        DEFAULT_HEADERS.add("Cc");
        DEFAULT_HEADERS.add("Content-Type");
        DEFAULT_HEADERS.add("Message-ID");
    }
}

