/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.cockpit;

import io.gravitee.cockpit.api.CockpitConnector;
import io.gravitee.plugin.core.api.AbstractSpringPluginHandler;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import io.gravitee.plugin.core.api.PluginType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class CockpitPluginHandler
extends AbstractSpringPluginHandler<CockpitConnector> {
    @Autowired
    private PluginClassLoaderFactory<Plugin> pluginClassLoaderFactory;
    @Autowired
    private ApplicationContext applicationContext;

    public boolean canHandle(Plugin plugin) {
        return plugin.type().equalsIgnoreCase(this.type());
    }

    protected String type() {
        return PluginType.COCKPIT.name();
    }

    protected void register(CockpitConnector connector) {
        try {
            connector.start();
            this.registerBean(connector);
        }
        catch (Exception e) {
            this.logger.error("Unexpected error while starting cockpit controller", (Throwable)e);
        }
    }

    protected ClassLoader getClassLoader(Plugin plugin) throws Exception {
        return this.pluginClassLoaderFactory.getOrCreateClassLoader(plugin, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void registerBean(CockpitConnector connector) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        beanFactory.registerSingleton(CockpitConnector.class.getName(), (Object)connector);
    }
}

