/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.v3.json2xml;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.stream.TransformableRequestStreamBuilder;
import io.gravitee.gateway.api.http.stream.TransformableResponseStreamBuilder;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.gateway.api.stream.exception.TransformationException;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.api.annotations.OnResponseContent;
import io.gravitee.policy.json2xml.configuration.JsonToXmlTransformationPolicyConfiguration;
import io.gravitee.policy.json2xml.configuration.PolicyScope;
import io.gravitee.policy.json2xml.transformer.JSONObject;
import io.gravitee.policy.json2xml.transformer.XML;
import io.gravitee.policy.json2xml.utils.CharsetHelper;
import java.nio.charset.Charset;
import java.util.function.Function;

public class JsonToXmlTransformationPolicyV3 {
    public static final String UTF8_CHARSET_NAME = "UTF-8";
    public static final String CONTENT_TYPE = "application/xml;charset=UTF-8";
    protected final JsonToXmlTransformationPolicyConfiguration configuration;
    protected Integer maxDepth;

    public JsonToXmlTransformationPolicyV3(JsonToXmlTransformationPolicyConfiguration configuration) {
        this.configuration = configuration;
    }

    @OnResponseContent
    public ReadWriteStream onResponseContent(Response response, PolicyChain chain, ExecutionContext ctx) {
        if (this.configuration.getScope() == null || this.configuration.getScope() == PolicyScope.RESPONSE) {
            Charset charset = CharsetHelper.extractCharset(response.headers());
            return TransformableResponseStreamBuilder.on((Response)response).chain(chain).contentType(CONTENT_TYPE).transform(this.map(charset, ctx)).build();
        }
        return null;
    }

    @OnRequestContent
    public ReadWriteStream onRequestContent(Request request, PolicyChain chain, ExecutionContext ctx) {
        if (this.configuration.getScope() == PolicyScope.REQUEST) {
            Charset charset = CharsetHelper.extractCharset(request.headers());
            return TransformableRequestStreamBuilder.on((Request)request).chain(chain).contentType(CONTENT_TYPE).transform(this.map(charset, ctx)).build();
        }
        return null;
    }

    private Function<Buffer, Buffer> map(Charset charset, ExecutionContext ctx) {
        return input -> {
            try {
                String encodedPayload = new String(input.toString(charset).getBytes(UTF8_CHARSET_NAME));
                JSONObject jsonPayload = new JSONObject(encodedPayload, this.getMaxDepth(ctx));
                JSONObject jsonPayloadWithRoot = new JSONObject();
                jsonPayloadWithRoot.append(this.configuration.getRootElement(), jsonPayload);
                return Buffer.buffer((String)XML.toString(jsonPayloadWithRoot));
            }
            catch (Exception ex) {
                throw new TransformationException("Unable to transform JSON into XML: " + ex.getMessage(), (Throwable)ex);
            }
        };
    }

    protected int getMaxDepth(ExecutionContext ctx) {
        if (this.maxDepth == null) {
            this.maxDepth = (Integer)((Configuration)ctx.getComponent(Configuration.class)).getProperty("policy.json-xml.maxdepth", Integer.class, (Object)100);
        }
        return this.maxDepth;
    }
}

