/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.oauth2;

import io.gravitee.common.security.jwt.LazyJWT;
import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.context.GenericExecutionContext;
import io.gravitee.gateway.reactive.api.context.HttpExecutionContext;
import io.gravitee.gateway.reactive.api.policy.SecurityPolicy;
import io.gravitee.gateway.reactive.api.policy.SecurityToken;
import io.gravitee.policy.api.annotations.RequireResource;
import io.gravitee.policy.oauth2.configuration.OAuth2PolicyConfiguration;
import io.gravitee.policy.oauth2.introspection.TokenIntrospectionCache;
import io.gravitee.policy.oauth2.introspection.TokenIntrospectionResult;
import io.gravitee.policy.oauth2.resource.CacheElement;
import io.gravitee.policy.oauth2.utils.TokenExtractor;
import io.gravitee.policy.v3.oauth2.Oauth2PolicyV3;
import io.gravitee.resource.api.ResourceManager;
import io.gravitee.resource.cache.api.Cache;
import io.gravitee.resource.cache.api.CacheResource;
import io.gravitee.resource.cache.api.Element;
import io.gravitee.resource.oauth2.api.OAuth2Resource;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleEmitter;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequireResource
public class Oauth2Policy
extends Oauth2PolicyV3
implements SecurityPolicy {
    public static final String CONTEXT_ATTRIBUTE_JWT = "jwt";
    public static final String CONTEXT_ATTRIBUTE_TOKEN = "oauth.token";
    public static final String ATTR_INTERNAL_TOKEN_INTROSPECTIONS = "token-introspection-cache";
    private static final Logger log = LoggerFactory.getLogger(Oauth2Policy.class);

    public Oauth2Policy(OAuth2PolicyConfiguration oAuth2PolicyConfiguration) {
        super(oAuth2PolicyConfiguration);
    }

    public String id() {
        return "oauth2";
    }

    public int order() {
        return 100;
    }

    public boolean requireSubscription() {
        return true;
    }

    public Maybe<SecurityToken> extractSecurityToken(HttpExecutionContext ctx) {
        OAuth2Resource<?> oauth2Resource = this.getOauth2Resource(ctx);
        if (oauth2Resource == null) {
            log.debug("Skipping security token extraction cause no oauth2 resource configured");
            return Maybe.empty();
        }
        return this.extractAccessToken(ctx, true).flatMap(token -> this.introspectAccessToken(ctx, (String)token, oauth2Resource).toMaybe()).flatMap(introspectionResult -> {
            if (introspectionResult.hasClientId()) {
                return Maybe.just((Object)SecurityToken.forClientId((String)introspectionResult.getClientId()));
            }
            return Maybe.just((Object)SecurityToken.invalid((SecurityToken.TokenType)SecurityToken.TokenType.CLIENT_ID));
        });
    }

    public Completable onRequest(HttpExecutionContext ctx) {
        return this.handleSecurity(ctx);
    }

    private Completable handleSecurity(HttpExecutionContext ctx) {
        return Completable.defer(() -> {
            log.debug("Read access_token from request {}", (Object)ctx.request().id());
            OAuth2Resource<?> oauth2Resource = this.getOauth2Resource(ctx);
            if (oauth2Resource == null) {
                return ctx.interruptWith(new ExecutionFailure(401).key("OAUTH2_MISSING_SERVER").message("Unauthorized"));
            }
            return this.extractAccessToken(ctx, false).switchIfEmpty((MaybeSource)Maybe.defer(() -> this.sendError(ctx, "OAUTH2_MISSING_HEADER").toMaybe())).flatMapCompletable(accessToken -> {
                if (accessToken.isBlank()) {
                    return this.sendError(ctx, "OAUTH2_MISSING_ACCESS_TOKEN");
                }
                ctx.setAttribute("oauth.access_token", accessToken);
                return this.introspectAndValidateAccessToken(ctx, (String)accessToken, oauth2Resource);
            });
        }).doOnTerminate(() -> {
            if (!this.oAuth2PolicyConfiguration.isPropagateAuthHeader()) {
                ctx.request().headers().remove((CharSequence)"Authorization");
            }
        });
    }

    private Maybe<String> extractAccessToken(HttpExecutionContext ctx, boolean canUseCache) {
        return Maybe.defer(() -> {
            LazyJWT jwt;
            LazyJWT lazyJWT = jwt = canUseCache ? (LazyJWT)ctx.getAttribute(CONTEXT_ATTRIBUTE_JWT) : null;
            if (jwt == null) {
                Optional<String> token = TokenExtractor.extract(ctx.request());
                if (token.isEmpty()) {
                    return Maybe.empty();
                }
                jwt = new LazyJWT(token.get());
                ctx.setAttribute(CONTEXT_ATTRIBUTE_JWT, (Object)jwt);
            }
            return Maybe.just((Object)jwt.getToken());
        }).doOnSuccess(token -> ctx.setAttribute(CONTEXT_ATTRIBUTE_TOKEN, token));
    }

    private Completable validateOAuth2Payload(HttpExecutionContext ctx, TokenIntrospectionResult tokenIntrospectionResult, OAuth2Resource<?> oauth2Resource) {
        String user;
        if (!tokenIntrospectionResult.hasValidPayload()) {
            return this.sendError(ctx, "OAUTH2_INVALID_SERVER_RESPONSE");
        }
        if (tokenIntrospectionResult.hasClientId()) {
            ctx.setAttribute("oauth.client_id", (Object)tokenIntrospectionResult.getClientId());
        }
        if ((user = tokenIntrospectionResult.extractUser(oauth2Resource.getUserClaim())) != null && !user.trim().isEmpty()) {
            ctx.setAttribute("gravitee.attribute.user", (Object)user);
            ctx.metrics().setUser(user);
        }
        List<String> scopes = tokenIntrospectionResult.extractScopes(oauth2Resource.getScopeSeparator());
        ctx.setAttribute("gravitee.attribute.user.roles", scopes);
        if (this.oAuth2PolicyConfiguration.isCheckRequiredScopes() && !Oauth2Policy.hasRequiredScopes(scopes, this.oAuth2PolicyConfiguration.getRequiredScopes(), this.oAuth2PolicyConfiguration.isModeStrict())) {
            return this.sendError(ctx, "OAUTH2_INSUFFICIENT_SCOPE");
        }
        if (this.oAuth2PolicyConfiguration.isExtractPayload()) {
            ctx.setAttribute("oauth.payload", (Object)tokenIntrospectionResult.getOauth2ResponsePayload());
        }
        return Completable.complete();
    }

    protected Single<TokenIntrospectionResult> introspectAccessToken(HttpExecutionContext ctx, String accessToken, OAuth2Resource<?> oauth2Resource) {
        Element element;
        TokenIntrospectionCache tokenIntrospectionCache = this.getContextTokenIntrospectionCache(ctx);
        if (tokenIntrospectionCache.contains(accessToken, oauth2Resource)) {
            log.debug("Token as already been introspected by this Oauth resource on the current request. Re-using cached response.");
            return Single.just((Object)tokenIntrospectionCache.get(accessToken, oauth2Resource).get());
        }
        Cache policyCache = this.getPolicyTokenIntrospectionCache(ctx);
        if (policyCache != null && (element = policyCache.get((Object)accessToken)) != null) {
            log.debug("Token as already been introspected in the policy level cache. Re-using cached response.");
            return Single.just((Object)new TokenIntrospectionResult((String)element.value()));
        }
        Single oAuth2Response = Single.create(emitter -> oauth2Resource.introspect(accessToken, arg_0 -> ((SingleEmitter)emitter).onSuccess(arg_0)));
        return oAuth2Response.map(TokenIntrospectionResult::new).doOnSuccess(tokenIntrospectionResult -> Oauth2Policy.fillTokenIntrospectionCache(accessToken, oauth2Resource, tokenIntrospectionCache, policyCache, tokenIntrospectionResult));
    }

    private Completable introspectAndValidateAccessToken(HttpExecutionContext ctx, String accessToken, OAuth2Resource<?> oauth2Resource) {
        return this.introspectAccessToken(ctx, accessToken, oauth2Resource).flatMapCompletable(introspectionResult -> {
            if (introspectionResult.isSuccess()) {
                return this.validateOAuth2Payload(ctx, (TokenIntrospectionResult)introspectionResult, oauth2Resource);
            }
            ctx.response().headers().add((CharSequence)"WWW-Authenticate", (CharSequence)"Bearer realm=gravitee.io ");
            if (introspectionResult.getOauth2ResponseThrowable() == null) {
                return ctx.interruptWith(new ExecutionFailure(401).key("OAUTH2_INVALID_ACCESS_TOKEN").message("Unauthorized"));
            }
            return ctx.interruptWith(new ExecutionFailure(503).key("OAUTH2_SERVER_UNAVAILABLE").message("temporarily_unavailable"));
        });
    }

    private Completable sendError(HttpExecutionContext ctx, String responseKey) {
        String headerValue = "Bearer realm=\"gravitee.io\"";
        ctx.response().headers().add((CharSequence)"WWW-Authenticate", (CharSequence)headerValue);
        return ctx.interruptWith(new ExecutionFailure(401).key(responseKey).message("Unauthorized"));
    }

    private OAuth2Resource<?> getOauth2Resource(HttpExecutionContext ctx) {
        if (this.oAuth2PolicyConfiguration.getOauthResource() == null) {
            return null;
        }
        return (OAuth2Resource)((ResourceManager)ctx.getComponent(ResourceManager.class)).getResource((String)ctx.getTemplateEngine().getValue(this.oAuth2PolicyConfiguration.getOauthResource(), String.class), OAuth2Resource.class);
    }

    private Cache getPolicyTokenIntrospectionCache(HttpExecutionContext ctx) {
        CacheResource cacheResource;
        if (this.oAuth2PolicyConfiguration.getOauthCacheResource() != null && (cacheResource = (CacheResource)((ResourceManager)ctx.getComponent(ResourceManager.class)).getResource(this.oAuth2PolicyConfiguration.getOauthCacheResource(), CacheResource.class)) != null) {
            return cacheResource.getCache((GenericExecutionContext)ctx);
        }
        return null;
    }

    private TokenIntrospectionCache getContextTokenIntrospectionCache(HttpExecutionContext ctx) {
        TokenIntrospectionCache cache = (TokenIntrospectionCache)ctx.getInternalAttribute(ATTR_INTERNAL_TOKEN_INTROSPECTIONS);
        if (cache == null) {
            cache = new TokenIntrospectionCache();
            ctx.setInternalAttribute(ATTR_INTERNAL_TOKEN_INTROSPECTIONS, (Object)cache);
        }
        return cache;
    }

    private static void fillTokenIntrospectionCache(String accessToken, OAuth2Resource<?> oauth2Resource, TokenIntrospectionCache tokenIntrospectionCache, Cache policyCache, TokenIntrospectionResult tokenIntrospectionResult) {
        tokenIntrospectionCache.put(accessToken, oauth2Resource, tokenIntrospectionResult);
        if (policyCache != null && tokenIntrospectionResult.isSuccess() && tokenIntrospectionResult.hasValidPayload()) {
            CacheElement element = new CacheElement(accessToken, (Serializable)((Object)tokenIntrospectionResult.getOauth2ResponsePayload()));
            if (tokenIntrospectionResult.hasExpirationTime()) {
                long ttl = tokenIntrospectionResult.getExpirationTime() - System.currentTimeMillis() / 1000L;
                element.setTimeToLive(Long.valueOf(ttl).intValue());
            }
            policyCache.put((Element)element);
        }
    }
}

