/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.oauth2.introspection;

import io.gravitee.policy.oauth2.introspection.TokenIntrospectionResult;
import io.gravitee.resource.oauth2.api.OAuth2Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TokenIntrospectionCache {
    private final Map<Integer, TokenIntrospectionResult> cache = new HashMap<Integer, TokenIntrospectionResult>();

    public boolean contains(String accessToken, OAuth2Resource oAuth2Resource) {
        return this.cache.containsKey(this.buildCacheKey(accessToken, oAuth2Resource));
    }

    public Optional<TokenIntrospectionResult> get(String accessToken, OAuth2Resource oAuth2Resource) {
        return Optional.ofNullable(this.cache.get(this.buildCacheKey(accessToken, oAuth2Resource)));
    }

    public void put(String accessToken, OAuth2Resource oAuth2Resource, TokenIntrospectionResult tokenIntrospectionResult) {
        this.cache.put(this.buildCacheKey(accessToken, oAuth2Resource), tokenIntrospectionResult);
    }

    private Integer buildCacheKey(String accessToken, OAuth2Resource oAuth2Resource) {
        return Objects.hash(accessToken, oAuth2Resource);
    }
}

