/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.oauth2.introspection;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.gravitee.policy.oauth2.Oauth2Policy;
import io.gravitee.resource.oauth2.api.OAuth2Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenIntrospectionResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(Oauth2Policy.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String OAUTH_PAYLOAD_SCOPE_NODE = "scope";
    public static final String OAUTH_PAYLOAD_SCOPE_NODE_LEGACY = "scp";
    public static final String OAUTH_PAYLOAD_CLIENT_ID_NODE = "client_id";
    public static final String OAUTH_PAYLOAD_SUB_NODE = "sub";
    public static final String OAUTH_PAYLOAD_EXP = "exp";
    private String oauth2ResponsePayload;
    private boolean success;
    private JsonNode oAuth2ResponseJsonNode;
    private Throwable oauth2ResponseThrowable;

    public TokenIntrospectionResult(OAuth2Response oAuth2Response) {
        this.success = oAuth2Response.isSuccess();
        this.oauth2ResponsePayload = oAuth2Response.getPayload();
        this.oauth2ResponseThrowable = oAuth2Response.getThrowable();
        this.oAuth2ResponseJsonNode = this.readPayload();
    }

    public TokenIntrospectionResult(String oauth2ResponsePayload) {
        this.success = true;
        this.oauth2ResponsePayload = oauth2ResponsePayload;
        this.oAuth2ResponseJsonNode = this.readPayload();
    }

    public String getClientId() {
        if (this.hasValidPayload()) {
            return this.oAuth2ResponseJsonNode.path(OAUTH_PAYLOAD_CLIENT_ID_NODE).asText();
        }
        return null;
    }

    public boolean hasClientId() {
        return this.getClientId() != null && !this.getClientId().isBlank();
    }

    public Long getExpirationTime() {
        if (this.hasValidPayload() && this.oAuth2ResponseJsonNode.has(OAUTH_PAYLOAD_EXP)) {
            return this.oAuth2ResponseJsonNode.get(OAUTH_PAYLOAD_EXP).asLong();
        }
        return null;
    }

    public boolean hasExpirationTime() {
        return this.getExpirationTime() != null;
    }

    public List<String> extractScopes(String scopeSeparator) {
        if (this.hasValidPayload()) {
            List<String> scopes;
            JsonNode scopesNode = this.oAuth2ResponseJsonNode.path(OAUTH_PAYLOAD_SCOPE_NODE);
            if (scopesNode.isMissingNode()) {
                scopesNode = this.oAuth2ResponseJsonNode.path(OAUTH_PAYLOAD_SCOPE_NODE_LEGACY);
            }
            if (scopesNode instanceof ArrayNode) {
                Iterator scopeIterator = scopesNode.elements();
                scopes = new ArrayList<String>(scopesNode.size());
                scopeIterator.forEachRemaining(jsonNode -> scopes.add(jsonNode.asText()));
            } else {
                scopes = Arrays.asList(scopesNode.asText().split(scopeSeparator));
            }
            return scopes;
        }
        return new ArrayList<String>();
    }

    public String extractUser(String userClaim) {
        if (this.hasValidPayload()) {
            return this.oAuth2ResponseJsonNode.path(userClaim == null ? OAUTH_PAYLOAD_SUB_NODE : userClaim).asText();
        }
        return null;
    }

    private JsonNode readPayload(String payload) {
        try {
            return MAPPER.readTree(payload);
        }
        catch (IOException ioe) {
            LOGGER.error("Unable to read Oauth2 token payload : {}", (Object)payload);
            return null;
        }
    }

    private JsonNode readPayload() {
        if (this.success && this.oauth2ResponsePayload != null) {
            return this.readPayload(this.oauth2ResponsePayload);
        }
        return null;
    }

    public boolean hasValidPayload() {
        return this.oAuth2ResponseJsonNode != null;
    }

    public String getOauth2ResponsePayload() {
        return this.oauth2ResponsePayload;
    }

    public Throwable getOauth2ResponseThrowable() {
        return this.oauth2ResponseThrowable;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

