/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.oauth2.utils;

import io.gravitee.common.util.MultiValueMap;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.reactive.api.context.HttpRequest;
import java.util.List;
import java.util.Optional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class TokenExtractor {
    static final String BEARER = "Bearer";
    static final String ACCESS_TOKEN = "access_token";

    public static Optional<String> extract(HttpRequest request) {
        return TokenExtractor.extractFromHeaders(request.headers()).or(() -> TokenExtractor.extractFromParameters((MultiValueMap<String, String>)request.parameters()));
    }

    @Deprecated
    public static String extract(Request request) {
        return TokenExtractor.extractFromHeaders(request.headers()).or(() -> TokenExtractor.extractFromParameters((MultiValueMap<String, String>)request.parameters())).orElse(null);
    }

    private static Optional<String> extractFromHeaders(HttpHeaders headers) {
        Optional<String> authorizationBearerHeader;
        List authorizationHeaders;
        if (headers != null && !ObjectUtils.isEmpty((Object)(authorizationHeaders = headers.getAll((CharSequence)"Authorization"))) && (authorizationBearerHeader = authorizationHeaders.stream().filter(h -> StringUtils.startsWithIgnoreCase((String)h, (String)BEARER)).findFirst()).isPresent()) {
            return Optional.of(authorizationBearerHeader.get().substring(BEARER.length()).trim());
        }
        return Optional.empty();
    }

    private static Optional<String> extractFromParameters(MultiValueMap<String, String> parameters) {
        if (parameters != null) {
            return Optional.ofNullable((String)parameters.getFirst((Object)ACCESS_TOKEN));
        }
        return Optional.empty();
    }
}

