/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.v3.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.RequireResource;
import io.gravitee.policy.oauth2.configuration.OAuth2PolicyConfiguration;
import io.gravitee.policy.oauth2.resource.CacheElement;
import io.gravitee.resource.api.ResourceManager;
import io.gravitee.resource.cache.api.CacheResource;
import io.gravitee.resource.cache.api.Element;
import io.gravitee.resource.oauth2.api.OAuth2Resource;
import io.gravitee.resource.oauth2.api.OAuth2Response;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@RequireResource
public class Oauth2PolicyV3 {
    private final Logger logger = LoggerFactory.getLogger(Oauth2PolicyV3.class);
    public static final String BEARER_AUTHORIZATION_TYPE = "Bearer";
    public static final String OAUTH_PAYLOAD_SCOPE_NODE = "scope";
    public static final String OAUTH_PAYLOAD_SCOPE_NODE_LEGACY = "scp";
    public static final String OAUTH_PAYLOAD_CLIENT_ID_NODE = "client_id";
    public static final String OAUTH_PAYLOAD_SUB_NODE = "sub";
    public static final String OAUTH_PAYLOAD_EXP = "exp";
    public static final String CONTEXT_ATTRIBUTE_PREFIX = "oauth.";
    public static final String CONTEXT_ATTRIBUTE_OAUTH_PAYLOAD = "oauth.payload";
    public static final String CONTEXT_ATTRIBUTE_OAUTH_ACCESS_TOKEN = "oauth.access_token";
    public static final String CONTEXT_ATTRIBUTE_CLIENT_ID = "oauth.client_id";
    public static final String OAUTH2_MISSING_SERVER_KEY = "OAUTH2_MISSING_SERVER";
    public static final String OAUTH2_MISSING_HEADER_KEY = "OAUTH2_MISSING_HEADER";
    public static final String OAUTH2_MISSING_ACCESS_TOKEN_KEY = "OAUTH2_MISSING_ACCESS_TOKEN";
    public static final String OAUTH2_INVALID_ACCESS_TOKEN_KEY = "OAUTH2_INVALID_ACCESS_TOKEN";
    public static final String OAUTH2_INVALID_SERVER_RESPONSE_KEY = "OAUTH2_INVALID_SERVER_RESPONSE";
    public static final String OAUTH2_INSUFFICIENT_SCOPE_KEY = "OAUTH2_INSUFFICIENT_SCOPE";
    public static final String OAUTH2_SERVER_UNAVAILABLE_KEY = "OAUTH2_SERVER_UNAVAILABLE";
    public static final String OAUTH2_UNAUTHORIZED_MESSAGE = "Unauthorized";
    public static final String OAUTH2_TEMPORARILY_UNAVAILABLE_MESSAGE = "temporarily_unavailable";
    static final ObjectMapper MAPPER = new ObjectMapper();
    protected final OAuth2PolicyConfiguration oAuth2PolicyConfiguration;

    public Oauth2PolicyV3(OAuth2PolicyConfiguration oAuth2PolicyConfiguration) {
        this.oAuth2PolicyConfiguration = oAuth2PolicyConfiguration;
    }

    @OnRequest
    public void onRequest(Request request, Response response, ExecutionContext executionContext, PolicyChain policyChain) {
        this.logger.debug("Read access_token from request {}", (Object)request.id());
        this.oAuth2PolicyConfiguration.setOauthResource((String)executionContext.getTemplateEngine().getValue(this.oAuth2PolicyConfiguration.getOauthResource(), String.class));
        OAuth2Resource oauth2 = (OAuth2Resource)((ResourceManager)executionContext.getComponent(ResourceManager.class)).getResource(this.oAuth2PolicyConfiguration.getOauthResource(), OAuth2Resource.class);
        if (oauth2 == null) {
            policyChain.failWith(PolicyResult.failure((String)OAUTH2_MISSING_SERVER_KEY, (int)401, (String)OAUTH2_UNAUTHORIZED_MESSAGE));
            return;
        }
        String authorizationHeader = request.headers().get((CharSequence)"Authorization");
        if (authorizationHeader == null || authorizationHeader.isEmpty() || !StringUtils.startsWithIgnoreCase((String)authorizationHeader, (String)BEARER_AUTHORIZATION_TYPE)) {
            this.sendError(OAUTH2_MISSING_HEADER_KEY, response, policyChain);
            return;
        }
        String accessToken = authorizationHeader.substring(BEARER_AUTHORIZATION_TYPE.length()).trim();
        if (accessToken.isEmpty()) {
            this.sendError(OAUTH2_MISSING_ACCESS_TOKEN_KEY, response, policyChain);
            return;
        }
        executionContext.setAttribute(CONTEXT_ATTRIBUTE_OAUTH_ACCESS_TOKEN, (Object)accessToken);
        CacheResource cacheResource = (CacheResource)((ResourceManager)executionContext.getComponent(ResourceManager.class)).getResource(this.oAuth2PolicyConfiguration.getOauthCacheResource(), CacheResource.class);
        if (cacheResource != null) {
            Element element = cacheResource.getCache(executionContext).get((Object)accessToken);
            if (element != null) {
                String oauth2payload = (String)element.value();
                this.handleSuccess(policyChain, request, response, executionContext, oauth2payload, null);
            } else {
                oauth2.introspect(accessToken, this.handleResponse(policyChain, request, response, executionContext, cacheResource));
            }
        } else {
            oauth2.introspect(accessToken, this.handleResponse(policyChain, request, response, executionContext, null));
        }
        if (!this.oAuth2PolicyConfiguration.isPropagateAuthHeader()) {
            request.headers().remove((CharSequence)"Authorization");
        }
    }

    Handler<OAuth2Response> handleResponse(PolicyChain policyChain, Request request, Response response, ExecutionContext executionContext, CacheResource cacheResource) {
        return oauth2response -> {
            if (oauth2response.isSuccess()) {
                this.handleSuccess(policyChain, request, response, executionContext, oauth2response.getPayload(), cacheResource);
            } else {
                response.headers().add((CharSequence)"WWW-Authenticate", (CharSequence)"Bearer realm=gravitee.io");
                if (oauth2response.getThrowable() == null) {
                    policyChain.failWith(PolicyResult.failure((String)OAUTH2_INVALID_ACCESS_TOKEN_KEY, (int)401, (String)OAUTH2_UNAUTHORIZED_MESSAGE));
                } else {
                    policyChain.failWith(PolicyResult.failure((String)OAUTH2_SERVER_UNAVAILABLE_KEY, (int)503, (String)OAUTH2_TEMPORARILY_UNAVAILABLE_MESSAGE));
                }
            }
        };
    }

    private void handleSuccess(PolicyChain policyChain, Request request, Response response, ExecutionContext executionContext, String oauth2payload, CacheResource cacheResource) {
        OAuth2Resource oauth2;
        String user;
        JsonNode oauthResponseNode = this.readPayload(oauth2payload);
        if (oauthResponseNode == null) {
            this.sendError(OAUTH2_INVALID_SERVER_RESPONSE_KEY, response, policyChain);
            return;
        }
        String clientId = oauthResponseNode.path(OAUTH_PAYLOAD_CLIENT_ID_NODE).asText();
        if (clientId != null && !clientId.trim().isEmpty()) {
            executionContext.setAttribute(CONTEXT_ATTRIBUTE_CLIENT_ID, (Object)clientId);
        }
        if ((user = oauthResponseNode.path((oauth2 = (OAuth2Resource)((ResourceManager)executionContext.getComponent(ResourceManager.class)).getResource(this.oAuth2PolicyConfiguration.getOauthResource(), OAuth2Resource.class)).getUserClaim() == null ? OAUTH_PAYLOAD_SUB_NODE : oauth2.getUserClaim()).asText()) != null && !user.trim().isEmpty()) {
            executionContext.setAttribute("gravitee.attribute.user", (Object)user);
            request.metrics().setUser(user);
        }
        List<String> scopes = Oauth2PolicyV3.extractScopes(oauthResponseNode, oauth2.getScopeSeparator());
        executionContext.setAttribute("gravitee.attribute.user.roles", scopes);
        if (this.oAuth2PolicyConfiguration.isCheckRequiredScopes() && !Oauth2PolicyV3.hasRequiredScopes(scopes, this.oAuth2PolicyConfiguration.getRequiredScopes(), this.oAuth2PolicyConfiguration.isModeStrict())) {
            this.sendError(OAUTH2_INSUFFICIENT_SCOPE_KEY, response, policyChain);
            return;
        }
        if (this.oAuth2PolicyConfiguration.isExtractPayload()) {
            executionContext.setAttribute(CONTEXT_ATTRIBUTE_OAUTH_PAYLOAD, (Object)oauth2payload);
        }
        if (cacheResource != null) {
            String accessToken = (String)executionContext.getAttribute(CONTEXT_ATTRIBUTE_OAUTH_ACCESS_TOKEN);
            CacheElement element = new CacheElement(accessToken, (Serializable)((Object)oauth2payload));
            if (oauthResponseNode.has(OAUTH_PAYLOAD_EXP)) {
                long expTimestamp = oauthResponseNode.get(OAUTH_PAYLOAD_EXP).asLong();
                long ttl = expTimestamp - System.currentTimeMillis() / 1000L;
                element.setTimeToLive(Long.valueOf(ttl).intValue());
            }
            cacheResource.getCache(executionContext).put((Element)element);
        }
        policyChain.doNext(request, response);
    }

    private void sendError(String responseKey, Response response, PolicyChain policyChain) {
        String headerValue = "Bearer realm=\"gravitee.io\"";
        response.headers().add((CharSequence)"WWW-Authenticate", (CharSequence)headerValue);
        policyChain.failWith(PolicyResult.failure((String)responseKey, (int)401, (String)OAUTH2_UNAUTHORIZED_MESSAGE));
    }

    protected JsonNode readPayload(String oauthPayload) {
        try {
            return MAPPER.readTree(oauthPayload);
        }
        catch (IOException ioe) {
            this.logger.error("Unable to check required scope from introspection endpoint payload: {}", (Object)oauthPayload);
            return null;
        }
    }

    protected static List<String> extractScopes(JsonNode oauthResponseNode, String scopeSeparator) {
        List<String> scopes;
        JsonNode scopesNode = oauthResponseNode.path(OAUTH_PAYLOAD_SCOPE_NODE);
        if (scopesNode.isMissingNode()) {
            scopesNode = oauthResponseNode.path(OAUTH_PAYLOAD_SCOPE_NODE_LEGACY);
        }
        if (scopesNode instanceof ArrayNode) {
            Iterator scopeIterator = scopesNode.elements();
            List<String> finalScopes = scopes = new ArrayList<String>(scopesNode.size());
            scopeIterator.forEachRemaining(jsonNode -> finalScopes.add(jsonNode.asText()));
        } else {
            scopes = Arrays.asList(scopesNode.asText().split(scopeSeparator));
        }
        return scopes;
    }

    protected static boolean hasRequiredScopes(Collection<String> tokenScopes, List<String> requiredScopes, boolean modeStrict) {
        if (requiredScopes == null || requiredScopes.isEmpty()) {
            return true;
        }
        if (tokenScopes == null || tokenScopes.isEmpty()) {
            return false;
        }
        if (modeStrict) {
            return tokenScopes.containsAll(requiredScopes);
        }
        return tokenScopes.stream().anyMatch(requiredScopes::contains);
    }
}

