/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.rcl;

import io.gravitee.common.util.Maps;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.stream.BufferedReadWriteStream;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.gateway.api.stream.SimpleReadWriteStream;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.rcl.configuration.RequestContentLimitPolicyConfiguration;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContentLimitPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestContentLimitPolicy.class);
    private static final String REQUEST_CONTENT_LIMIT_TOO_LARGE = "REQUEST_CONTENT_LIMIT_TOO_LARGE";
    private static final String REQUEST_CONTENT_LIMIT_LENGTH_REQUIRED = "REQUEST_CONTENT_LIMIT_LENGTH_REQUIRED";
    private final RequestContentLimitPolicyConfiguration requestContentLimitPolicyConfiguration;

    public RequestContentLimitPolicy(RequestContentLimitPolicyConfiguration requestContentLimitPolicyConfiguration) {
        this.requestContentLimitPolicyConfiguration = requestContentLimitPolicyConfiguration;
    }

    @OnRequest
    public void onRequest(Request request, Response response, PolicyChain policyChain) {
        block7: {
            String contentLengthHeader = request.headers().get((CharSequence)"Content-Length");
            LOGGER.debug("Retrieve content-length from request: {}", (Object)contentLengthHeader);
            if (contentLengthHeader != null && !contentLengthHeader.isEmpty()) {
                try {
                    int contentLength = Integer.parseInt(contentLengthHeader);
                    if ((long)contentLength > this.requestContentLimitPolicyConfiguration.getLimit()) {
                        policyChain.failWith(PolicyResult.failure((String)REQUEST_CONTENT_LIMIT_TOO_LARGE, (int)413, (String)"The request is larger than the server is willing or able to process.", (Map)Maps.builder().put((Object)"length", (Object)contentLength).put((Object)"limit", (Object)this.requestContentLimitPolicyConfiguration.getLimit()).build()));
                        break block7;
                    }
                    policyChain.doNext(request, response);
                }
                catch (NumberFormatException nfe) {
                    policyChain.failWith(PolicyResult.failure((int)400, (String)"Content-length is not a valid integer !"));
                }
            } else if (this.isTransferEncoding(request)) {
                policyChain.doNext(request, response);
            } else {
                policyChain.failWith(PolicyResult.failure((String)REQUEST_CONTENT_LIMIT_LENGTH_REQUIRED, (int)411, (String)"The request did not specify the length of its content, which is required by the requested resource.", (Map)Maps.builder().put((Object)"limit", (Object)this.requestContentLimitPolicyConfiguration.getLimit()).build()));
            }
        }
    }

    @OnRequestContent
    public ReadWriteStream onRequestContent(Request request, final PolicyChain policyChain) {
        if (this.isTransferEncoding(request)) {
            return new BufferedReadWriteStream(){
                private long contentLength = 0L;

                public SimpleReadWriteStream<Buffer> write(Buffer content) {
                    this.contentLength += (long)content.length();
                    if (this.contentLength > RequestContentLimitPolicy.this.requestContentLimitPolicyConfiguration.getLimit()) {
                        policyChain.streamFailWith(PolicyResult.failure((String)RequestContentLimitPolicy.REQUEST_CONTENT_LIMIT_TOO_LARGE, (int)413, (String)"The request is larger than the server is willing or able to process.", (Map)Maps.builder().put((Object)"length", (Object)this.contentLength).put((Object)"limit", (Object)RequestContentLimitPolicy.this.requestContentLimitPolicyConfiguration.getLimit()).build()));
                        return this;
                    }
                    return super.write((Object)content);
                }

                public void end() {
                    super.end();
                }
            };
        }
        return null;
    }

    private boolean isTransferEncoding(Request request) {
        String transferEncoding = request.headers().get((CharSequence)"Transfer-Encoding");
        return transferEncoding != null && !transferEncoding.isEmpty();
    }
}

