/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.v3.xml2json;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.stream.TransformableRequestStreamBuilder;
import io.gravitee.gateway.api.http.stream.TransformableResponseStreamBuilder;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.gateway.api.stream.exception.TransformationException;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.api.annotations.OnResponseContent;
import io.gravitee.policy.xml2json.configuration.PolicyScope;
import io.gravitee.policy.xml2json.configuration.XmlToJsonTransformationPolicyConfiguration;
import io.gravitee.policy.xml2json.transformer.XML;
import io.gravitee.policy.xml2json.utils.CharsetHelper;
import java.nio.charset.Charset;
import java.util.function.Function;

public class XmlToJsonTransformationPolicyV3 {
    public static final String POLICY_XML_JSON_MAXDEPTH = "policy.xml-json.maxdepth";
    public static final int DEFAULT_MAX_DEPH = 100;
    public static final String UTF8_CHARSET_NAME = "UTF-8";
    public static final String APPLICATION_JSON = "application/json;charset=UTF-8";
    private Integer maxDepth;
    protected final XmlToJsonTransformationPolicyConfiguration xmlToJsonTransformationPolicyConfiguration;

    public XmlToJsonTransformationPolicyV3(XmlToJsonTransformationPolicyConfiguration xmlToJsonTransformationPolicyConfiguration) {
        this.xmlToJsonTransformationPolicyConfiguration = xmlToJsonTransformationPolicyConfiguration;
    }

    @OnResponseContent
    public ReadWriteStream onResponseContent(Response response, PolicyChain chain, ExecutionContext context) {
        if (this.xmlToJsonTransformationPolicyConfiguration.getScope() == null || this.xmlToJsonTransformationPolicyConfiguration.getScope() == PolicyScope.RESPONSE) {
            Charset charset = CharsetHelper.extractCharset(response.headers());
            return TransformableResponseStreamBuilder.on((Response)response).chain(chain).contentType(APPLICATION_JSON).transform(this.map(charset, this.getMaxDepth(context))).build();
        }
        return null;
    }

    @OnRequestContent
    public ReadWriteStream onRequestContent(Request request, PolicyChain chain, ExecutionContext context) {
        if (this.xmlToJsonTransformationPolicyConfiguration.getScope() == PolicyScope.REQUEST) {
            Charset charset = CharsetHelper.extractCharset(request.headers());
            return TransformableRequestStreamBuilder.on((Request)request).chain(chain).contentType(APPLICATION_JSON).transform(this.map(charset, this.getMaxDepth(context))).build();
        }
        return null;
    }

    private Function<Buffer, Buffer> map(Charset charset, int depth) {
        return input -> {
            try {
                String encodedPayload = new String(input.toString(charset).getBytes(UTF8_CHARSET_NAME));
                return Buffer.buffer((String)XML.toJSONObject(encodedPayload, depth).toString(), (String)UTF8_CHARSET_NAME);
            }
            catch (Exception ex) {
                throw new TransformationException("Unable to transform XML into JSON: " + ex.getMessage(), (Throwable)ex);
            }
        };
    }

    private int getMaxDepth(ExecutionContext context) {
        if (this.maxDepth == null) {
            this.maxDepth = (Integer)((Configuration)context.getComponent(Configuration.class)).getProperty(POLICY_XML_JSON_MAXDEPTH, Integer.class, (Object)100);
        }
        return this.maxDepth;
    }
}

