/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.xml2json;

import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.api.stream.exception.TransformationException;
import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.context.GenericExecutionContext;
import io.gravitee.gateway.reactive.api.context.HttpExecutionContext;
import io.gravitee.gateway.reactive.api.context.MessageExecutionContext;
import io.gravitee.gateway.reactive.api.message.Message;
import io.gravitee.gateway.reactive.api.policy.Policy;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.policy.v3.xml2json.XmlToJsonTransformationPolicyV3;
import io.gravitee.policy.xml2json.configuration.XmlToJsonTransformationPolicyConfiguration;
import io.gravitee.policy.xml2json.transformer.XML;
import io.gravitee.policy.xml2json.utils.CharsetHelper;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class XmlToJsonTransformationPolicy
extends XmlToJsonTransformationPolicyV3
implements Policy {
    private static final String INVALID_PAYLOAD_FAILURE_KEY = "XML_INVALID_PAYLOAD";
    private static final String INVALID_MESSAGE_PAYLOAD_FAILURE_KEY = "XML_INVALID_MESSAGE_PAYLOAD";
    private Integer maxDepth;

    public XmlToJsonTransformationPolicy(XmlToJsonTransformationPolicyConfiguration configuration) {
        super(configuration);
    }

    private static void setContentHeaders(HttpHeaders headers, Buffer jsonBuffer) {
        headers.set((CharSequence)"Content-Type", (CharSequence)"application/json;charset=UTF-8");
        headers.set((CharSequence)"Content-Length", (CharSequence)Integer.toString(jsonBuffer.length()));
    }

    public String id() {
        return "xml-json";
    }

    public Completable onRequest(HttpExecutionContext ctx) {
        return ctx.request().onBody(body -> this.transformBodyToJson(ctx, (Maybe<Buffer>)body, ctx.request().headers(), 400));
    }

    public Completable onResponse(HttpExecutionContext ctx) {
        return ctx.response().onBody(body -> this.transformBodyToJson(ctx, (Maybe<Buffer>)body, ctx.response().headers(), 500));
    }

    private Maybe<Buffer> transformBodyToJson(HttpExecutionContext ctx, Maybe<Buffer> bodyUpstream, HttpHeaders headers, int failureHttpCode) {
        return bodyUpstream.flatMap(buffer -> this.transformToJson((Buffer)buffer, CharsetHelper.extractCharset(headers), this.getMaxDepth((GenericExecutionContext)ctx))).doOnSuccess(jsonBuffer -> XmlToJsonTransformationPolicy.setContentHeaders(headers, jsonBuffer)).onErrorResumeWith((MaybeSource)ctx.interruptBodyWith(new ExecutionFailure(failureHttpCode).key(INVALID_PAYLOAD_FAILURE_KEY).message("Unable to transform invalid XML to Json")));
    }

    public Completable onMessageRequest(MessageExecutionContext ctx) {
        return ctx.request().onMessage(message -> this.transformMessageToJson(ctx, (Message)message, ctx.request().headers(), 400));
    }

    public Completable onMessageResponse(MessageExecutionContext ctx) {
        return ctx.response().onMessage(message -> this.transformMessageToJson(ctx, (Message)message, ctx.response().headers(), 500));
    }

    private Maybe<Message> transformMessageToJson(MessageExecutionContext ctx, Message message, HttpHeaders headers, int failureHttpCode) {
        return this.transformToJson(message.content(), CharsetHelper.extractCharset(headers), this.getMaxDepth((GenericExecutionContext)ctx)).map(arg_0 -> ((Message)message).content(arg_0)).doOnSuccess(jsonMessage -> XmlToJsonTransformationPolicy.setContentHeaders(message.headers(), jsonMessage.content())).onErrorResumeWith((MaybeSource)ctx.interruptMessageWith(new ExecutionFailure(failureHttpCode).key(INVALID_MESSAGE_PAYLOAD_FAILURE_KEY).message("Unable to transform invalid XML message to JSON")));
    }

    private int getMaxDepth(GenericExecutionContext ctx) {
        if (this.maxDepth == null) {
            this.maxDepth = (Integer)((Configuration)ctx.getComponent(Configuration.class)).getProperty("policy.xml-json.maxdepth", Integer.class, (Object)100);
        }
        return this.maxDepth;
    }

    private Maybe<Buffer> transformToJson(Buffer buffer, Charset charset, int depth) {
        try {
            String encodedPayload = new String(buffer.toString(charset).getBytes(StandardCharsets.UTF_8));
            return Maybe.just((Object)Buffer.buffer((String)XML.toJSONObject(encodedPayload, depth).toString(), (String)"UTF-8"));
        }
        catch (Exception e) {
            return Maybe.error((Throwable)new TransformationException("Unable to transform XML into JSON:" + e.getMessage(), (Throwable)e));
        }
    }
}

