/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.elasticsearch.indexer;

import io.gravitee.node.api.Node;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.common.formatter.Formatter;
import io.gravitee.reporter.common.formatter.FormatterFactory;
import io.gravitee.reporter.common.formatter.FormatterFactoryConfiguration;
import io.gravitee.reporter.common.formatter.Type;
import io.gravitee.reporter.elasticsearch.config.PipelineConfiguration;
import io.gravitee.reporter.elasticsearch.config.ReporterConfiguration;
import io.gravitee.reporter.elasticsearch.indexer.Indexer;
import io.gravitee.reporter.elasticsearch.indexer.name.IndexNameGenerator;
import io.vertx.core.buffer.Buffer;
import java.util.Map;

public abstract class AbstractIndexer
implements Indexer {
    private static final String INDEX_OPTION = "index";
    private static final String PIPELINE_OPTION = "pipeline";
    protected final ReporterConfiguration configuration;
    private final PipelineConfiguration pipelineConfiguration;
    private final IndexNameGenerator indexNameGenerator;
    private final Formatter<Reportable> formatter;

    protected AbstractIndexer(ReporterConfiguration configuration, PipelineConfiguration pipelineConfiguration, IndexNameGenerator indexNameGenerator, Node node) {
        this.configuration = configuration;
        this.pipelineConfiguration = pipelineConfiguration;
        this.indexNameGenerator = indexNameGenerator;
        this.formatter = new FormatterFactory(node, this.formatterFactoryConfiguration()).getFormatter(Type.ELASTICSEARCH);
    }

    protected Buffer transform(Reportable reportable) {
        Map<String, String> options = Map.of(INDEX_OPTION, this.indexNameGenerator.generate(reportable), PIPELINE_OPTION, this.pipelineConfiguration.getPipeline());
        return this.formatter.format(reportable, options);
    }

    protected abstract FormatterFactoryConfiguration formatterFactoryConfiguration();
}

