/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.elasticsearch.mapping.es7;

import io.gravitee.elasticsearch.utils.Type;
import io.gravitee.reporter.elasticsearch.config.PipelineConfiguration;
import io.gravitee.reporter.elasticsearch.mapping.PerTypeIndexPreparer;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.functions.Function;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ES7IndexPreparer
extends PerTypeIndexPreparer {
    @Autowired
    private PipelineConfiguration pipelineConfiguration;

    @Override
    public Completable prepare() {
        return this.indexMapping().andThen((CompletableSource)this.pipeline());
    }

    @Override
    protected Function<Type, CompletableSource> indexTypeMapper() {
        return type -> {
            String typeName = type.getType();
            String templateName = this.configuration.getIndexName() + "-" + typeName;
            String aliasName = this.configuration.getIndexName() + "-" + typeName;
            this.logger.debug("Trying to put template mapping for type[{}] name[{}]", (Object)typeName, (Object)templateName);
            Map<String, Object> data = this.getTemplateData();
            data.put("indexName", this.configuration.getIndexName() + "-" + typeName);
            String template = this.freeMarkerComponent.generateFromTemplate("/es7x/mapping/index-template-" + typeName + ".ftl", data);
            Completable templateCreationCompletable = this.client.putTemplate(templateName, template);
            if (this.configuration.isIlmManagedIndex()) {
                return templateCreationCompletable.andThen((CompletableSource)this.ensureAlias(aliasName));
            }
            return templateCreationCompletable;
        };
    }

    private Completable ensureAlias(String aliasName) {
        String aliasTemplate = this.freeMarkerComponent.generateFromTemplate("/es7x/alias/alias.ftl", Collections.singletonMap("aliasName", aliasName));
        return this.client.getAlias(aliasName).switchIfEmpty((MaybeSource)this.client.createIndexWithAlias(aliasName + "-000001", aliasTemplate).toMaybe()).ignoreElement();
    }

    private Completable pipeline() {
        String pipelineTemplate = this.pipelineConfiguration.createPipeline();
        if (pipelineTemplate != null && this.pipelineConfiguration.getPipelineName() != null) {
            return this.client.putPipeline(this.pipelineConfiguration.getPipelineName(), pipelineTemplate).doOnComplete(() -> this.pipelineConfiguration.valid());
        }
        return Completable.complete();
    }
}

