/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.elasticsearch.spring;

import io.gravitee.common.templating.FreeMarkerComponent;
import io.gravitee.elasticsearch.client.Client;
import io.gravitee.elasticsearch.client.http.ClientSslConfiguration;
import io.gravitee.elasticsearch.client.http.HttpClient;
import io.gravitee.elasticsearch.client.http.HttpClientConfiguration;
import io.gravitee.elasticsearch.client.http.HttpClientJksSslConfiguration;
import io.gravitee.elasticsearch.client.http.HttpClientPemSslConfiguration;
import io.gravitee.elasticsearch.client.http.HttpClientPfxSslConfiguration;
import io.gravitee.reporter.elasticsearch.config.PipelineConfiguration;
import io.gravitee.reporter.elasticsearch.config.ReporterConfiguration;
import io.vertx.core.Vertx;
import java.nio.file.Path;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ElasticsearchReporterConfiguration {
    @Bean
    public io.vertx.rxjava3.core.Vertx vertxRx(Vertx vertx) {
        return io.vertx.rxjava3.core.Vertx.newInstance((Vertx)vertx);
    }

    @Bean
    public Client httpClient(ReporterConfiguration reporterConfiguration) {
        HttpClientConfiguration clientConfiguration = new HttpClientConfiguration();
        clientConfiguration.setEndpoints(reporterConfiguration.getEndpoints());
        clientConfiguration.setUsername(reporterConfiguration.getUsername());
        clientConfiguration.setPassword(reporterConfiguration.getPassword());
        clientConfiguration.setRequestTimeout(reporterConfiguration.getRequestTimeout());
        clientConfiguration.setProxyType(reporterConfiguration.getProxyType());
        clientConfiguration.setProxyHttpHost(reporterConfiguration.getProxyHttpHost());
        clientConfiguration.setProxyHttpPort(reporterConfiguration.getProxyHttpPort());
        clientConfiguration.setProxyHttpUsername(reporterConfiguration.getProxyHttpUsername());
        clientConfiguration.setProxyHttpPassword(reporterConfiguration.getProxyHttpPassword());
        clientConfiguration.setProxyHttpsHost(reporterConfiguration.getProxyHttpsHost());
        clientConfiguration.setProxyHttpsPort(reporterConfiguration.getProxyHttpsPort());
        clientConfiguration.setProxyHttpsUsername(reporterConfiguration.getProxyHttpsUsername());
        clientConfiguration.setProxyHttpsPassword(reporterConfiguration.getProxyHttpsPassword());
        clientConfiguration.setProxyConfigured(reporterConfiguration.isProxyConfigured());
        if (reporterConfiguration.getSslKeystoreType() != null) {
            if (reporterConfiguration.getSslKeystoreType().equalsIgnoreCase("jks")) {
                clientConfiguration.setSslConfig((ClientSslConfiguration)new HttpClientJksSslConfiguration(reporterConfiguration.getSslKeystore(), reporterConfiguration.getSslKeystorePassword()));
            } else if (reporterConfiguration.getSslKeystoreType().equalsIgnoreCase("pfx")) {
                clientConfiguration.setSslConfig((ClientSslConfiguration)new HttpClientPfxSslConfiguration(reporterConfiguration.getSslKeystore(), reporterConfiguration.getSslKeystorePassword()));
            } else if (reporterConfiguration.getSslKeystoreType().equalsIgnoreCase("pem")) {
                clientConfiguration.setSslConfig((ClientSslConfiguration)new HttpClientPemSslConfiguration(reporterConfiguration.getSslPemCerts(), reporterConfiguration.getSslPemKeys()));
            }
        }
        return new HttpClient(clientConfiguration);
    }

    @Bean
    public ReporterConfiguration configuration() {
        return new ReporterConfiguration();
    }

    @Bean
    public FreeMarkerComponent freeMarkerComponent(@Value(value="${reporters.elasticsearch.template_mapping.path:#{null}}") String templateMappingPath) {
        return FreeMarkerComponent.builder().path(templateMappingPath != null ? Path.of(templateMappingPath, new String[0]) : null).classLoader(this.getClass().getClassLoader()).classLoaderTemplateBase("freemarker").build();
    }

    @Bean
    public PipelineConfiguration pipelineConfiguration(@Value(value="${reporters.elasticsearch.pipeline.plugins.ingest:geoip,user_agent}") String ingestPlugins, @Value(value="${reporters.elasticsearch.user_agent.regex_file:#{null}}") String userAgentRegexFile, FreeMarkerComponent freeMarkerComponent) {
        return new PipelineConfiguration(ingestPlugins, userAgentRegexFile, freeMarkerComponent);
    }
}

