/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.topology;

import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.topology.RefreshFutures;
import io.lettuce.core.cluster.topology.TimedAsyncCommand;
import io.lettuce.core.cluster.topology.TopologyComparators;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

class Requests {
    private final Map<RedisURI, TimedAsyncCommand<String, String, String>> rawViews;

    protected Requests() {
        this.rawViews = new TreeMap<RedisURI, TimedAsyncCommand<String, String, String>>(TopologyComparators.RedisURIComparator.INSTANCE);
    }

    private Requests(Map<RedisURI, TimedAsyncCommand<String, String, String>> rawViews) {
        this.rawViews = rawViews;
    }

    protected void addRequest(RedisURI redisURI, TimedAsyncCommand<String, String, String> command) {
        this.rawViews.put(redisURI, command);
    }

    protected long await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return RefreshFutures.awaitAll(timeout, timeUnit, this.rawViews.values());
    }

    protected Set<RedisURI> nodes() {
        return this.rawViews.keySet();
    }

    protected TimedAsyncCommand<String, String, String> getRequest(RedisURI redisURI) {
        return this.rawViews.get(redisURI);
    }

    protected Requests mergeWith(Requests requests) {
        TreeMap<RedisURI, TimedAsyncCommand<String, String, String>> result = new TreeMap<RedisURI, TimedAsyncCommand<String, String, String>>(TopologyComparators.RedisURIComparator.INSTANCE);
        result.putAll(this.rawViews);
        result.putAll(requests.rawViews);
        return new Requests(result);
    }
}

