/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.FluxSubscribeOnValue;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.OperatorDisposables;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.scheduler.Scheduler;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;

final class MonoSubscribeOnValue<T>
extends Mono<T>
implements Scannable {
    final T value;
    final Scheduler scheduler;

    MonoSubscribeOnValue(@Nullable T value, Scheduler scheduler) {
        this.value = value;
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        T v = this.value;
        if (v == null) {
            FluxSubscribeOnValue.ScheduledEmpty parent = new FluxSubscribeOnValue.ScheduledEmpty(actual);
            actual.onSubscribe(parent);
            try {
                parent.setFuture(this.scheduler.schedule(parent));
            }
            catch (RejectedExecutionException ree) {
                if (parent.future != OperatorDisposables.DISPOSED) {
                    actual.onError(Operators.onRejectedExecution(ree, actual.currentContext()));
                }
            }
        } else {
            actual.onSubscribe(new FluxSubscribeOnValue.ScheduledScalar<T>(actual, v, this.scheduler));
        }
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_ON) {
            return this.scheduler;
        }
        return null;
    }
}

