/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.publisher.NotFunRingBufferFields;
import io.micrometer.shaded.reactor.core.publisher.RingBuffer;
import io.micrometer.shaded.reactor.core.publisher.RingBufferProducer;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.function.Supplier;

final class NotFunRingBuffer<E>
extends NotFunRingBufferFields<E> {
    NotFunRingBuffer(Supplier<E> eventFactory, RingBufferProducer sequenceProducer) {
        super(eventFactory, sequenceProducer);
    }

    @Override
    E get(long sequence) {
        return this.elementAt(sequence);
    }

    @Override
    long next() {
        return this.next(1);
    }

    @Override
    long next(int n) {
        return this.sequenceProducer.next(n);
    }

    @Override
    void addGatingSequence(RingBuffer.Sequence gatingSequence) {
        this.sequenceProducer.addGatingSequence(gatingSequence);
    }

    @Override
    long getMinimumGatingSequence() {
        return this.getMinimumGatingSequence(null);
    }

    @Override
    long getMinimumGatingSequence(@Nullable RingBuffer.Sequence sequence) {
        return this.sequenceProducer.getMinimumSequence(sequence);
    }

    @Override
    boolean removeGatingSequence(RingBuffer.Sequence sequence) {
        return this.sequenceProducer.removeGatingSequence(sequence);
    }

    @Override
    RingBuffer.Reader newReader() {
        return this.sequenceProducer.newBarrier();
    }

    @Override
    long getCursor() {
        return this.sequenceProducer.getCursor();
    }

    @Override
    int bufferSize() {
        return this.bufferSize;
    }

    @Override
    void publish(long sequence) {
        this.sequenceProducer.publish(sequence);
    }

    @Override
    int getPending() {
        return (int)this.sequenceProducer.getPending();
    }

    @Override
    RingBufferProducer getSequencer() {
        return this.sequenceProducer;
    }
}

