/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.DefaultCookie;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientConfiguration;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperator;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import java.util.Objects;
import java.util.function.Function;

final class HttpClientCookieWhen
extends HttpClientOperator
implements Function<Bootstrap, Bootstrap> {
    final Function<? super Cookie, Mono<? extends Cookie>> cookie;
    final String name;

    HttpClientCookieWhen(HttpClient client, String name, Function<? super Cookie, Mono<? extends Cookie>> cookie) {
        super(client);
        this.cookie = Objects.requireNonNull(cookie, "cookie");
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }

    @Override
    public Bootstrap apply(Bootstrap bootstrap) {
        HttpClientConfiguration.deferredConf(bootstrap, conf -> this.cookie.apply(new DefaultCookie(this.name, "")).map(c -> HttpClientCookieWhen.cookie(conf, c)));
        return bootstrap;
    }

    static HttpClientConfiguration cookie(HttpClientConfiguration conf, Cookie c) {
        if (!c.value().isEmpty()) {
            if (conf.headers == null) {
                conf.headers = new DefaultHttpHeaders();
            }
            conf.headers.add((CharSequence)HttpHeaderNames.COOKIE, (Object)conf.cookieEncoder.encode(c));
        }
        return conf;
    }
}

