/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperator;
import io.micrometer.shaded.reactor.netty.tcp.ProxyProvider;
import io.micrometer.shaded.reactor.netty.tcp.SslProvider;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

final class HttpClientOnConnectMap
extends HttpClientOperator {
    final BiFunction<? super Mono<? extends Connection>, ? super Bootstrap, ? extends Mono<? extends Connection>> connector;

    HttpClientOnConnectMap(HttpClient client, BiFunction<? super Mono<? extends Connection>, ? super Bootstrap, ? extends Mono<? extends Connection>> connector) {
        super(client);
        this.connector = Objects.requireNonNull(connector, "mapConnect");
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return new OnConnectMapTcpClient(this.source.tcpConfiguration(), this.connector);
    }

    static final class OnConnectMapTcpClient
    extends TcpClient {
        final TcpClient sourceTcp;
        final BiFunction<? super Mono<? extends Connection>, ? super Bootstrap, ? extends Mono<? extends Connection>> connector;

        OnConnectMapTcpClient(TcpClient sourceTcp, BiFunction<? super Mono<? extends Connection>, ? super Bootstrap, ? extends Mono<? extends Connection>> connector) {
            this.connector = connector;
            this.sourceTcp = sourceTcp;
        }

        @Override
        public Bootstrap configure() {
            return this.sourceTcp.configure();
        }

        @Override
        public Mono<? extends Connection> connect(Bootstrap b) {
            return this.connector.apply(this.sourceTcp.connect(b), b);
        }

        @Override
        @Nullable
        public ProxyProvider proxyProvider() {
            return this.sourceTcp.proxyProvider();
        }

        @Override
        @Nullable
        public SslProvider sslProvider() {
            return this.sourceTcp.sslProvider();
        }
    }
}

