/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.ServerBootstrap;
import io.micrometer.shaded.io.netty.buffer.PooledByteBufAllocator;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.io.netty.channel.ChannelOption;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoSink;
import io.micrometer.shaded.reactor.netty.ChannelBindException;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.DisposableServer;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.AbortedException;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.http.HttpResources;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.tcp.InetSocketAddressUtil;
import io.micrometer.shaded.reactor.netty.tcp.SslProvider;
import io.micrometer.shaded.reactor.netty.tcp.TcpResources;
import io.micrometer.shaded.reactor.netty.tcp.TcpServer;
import io.micrometer.shaded.reactor.netty.tcp.TcpServerRunOn;
import io.micrometer.shaded.reactor.netty.tcp.TcpUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Supplier;

final class TcpServerBind
extends TcpServer {
    static final TcpServerBind INSTANCE = new TcpServerBind();
    final ServerBootstrap serverBootstrap = this.createServerBootstrap();

    TcpServerBind() {
        BootstrapHandlers.channelOperationFactory(this.serverBootstrap, TcpUtils.TCP_OPS);
    }

    @Override
    public Mono<? extends DisposableServer> bind(ServerBootstrap b) {
        SslProvider ssl = SslProvider.findSslSupport(b);
        if (ssl != null && ssl.getDefaultConfigurationType() == null) {
            ssl = SslProvider.updateDefaultConfiguration(ssl, SslProvider.DefaultConfigurationType.TCP);
            SslProvider.setBootstrap(b, ssl);
        }
        if (b.config().group() == null) {
            TcpServerRunOn.configure(b, LoopResources.DEFAULT_NATIVE, TcpResources.get());
        }
        return Mono.create(sink -> {
            ServerBootstrap bootstrap = b.clone();
            ConnectionObserver obs = BootstrapHandlers.connectionObserver(bootstrap);
            ConnectionObserver childObs = BootstrapHandlers.childConnectionObserver(bootstrap);
            ChannelOperations.OnSetup ops = BootstrapHandlers.channelOperationFactory(bootstrap);
            TcpServerBind.convertLazyLocalAddress(bootstrap);
            BootstrapHandlers.finalizeHandler(bootstrap, ops, (ConnectionObserver)new ChildObserver(childObs));
            ChannelFuture f = bootstrap.bind();
            DisposableBind disposableServer = new DisposableBind((MonoSink<DisposableServer>)sink, f, obs, bootstrap);
            f.addListener(disposableServer);
            sink.onCancel(disposableServer);
        });
    }

    @Override
    public ServerBootstrap configure() {
        return this.serverBootstrap.clone();
    }

    static void convertLazyLocalAddress(ServerBootstrap b) {
        InetSocketAddress localInet;
        SocketAddress local = b.config().localAddress();
        Objects.requireNonNull(local, "Remote Address not configured");
        if (local instanceof Supplier) {
            Supplier lazyLocal = (Supplier)((Object)local);
            b.localAddress(Objects.requireNonNull((SocketAddress)lazyLocal.get(), "address supplier returned  null"));
        }
        if (local instanceof InetSocketAddress && (localInet = (InetSocketAddress)local).isUnresolved()) {
            b.localAddress(InetSocketAddressUtil.createResolved(localInet.getHostName(), localInet.getPort()));
        }
    }

    ServerBootstrap createServerBootstrap() {
        return (ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_BACKLOG, 1000)).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_RCVBUF, 0x100000).childOption(ChannelOption.SO_SNDBUF, 0x100000).childOption(ChannelOption.AUTO_READ, false).childOption(ChannelOption.SO_KEEPALIVE, true).childOption(ChannelOption.TCP_NODELAY, true).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, 30000).localAddress(new InetSocketAddress(0));
    }

    static final class ChildObserver
    implements ConnectionObserver {
        final ConnectionObserver childObs;

        ChildObserver(ConnectionObserver childObs) {
            this.childObs = childObs;
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            ChannelOperations<?, ?> ops = ChannelOperations.get(connection.channel());
            if (ops == null && (error instanceof IOException || AbortedException.isConnectionReset(error))) {
                if (TcpServer.log.isDebugEnabled()) {
                    TcpServer.log.debug(ReactorNetty.format(connection.channel(), "onUncaughtException(" + connection + ")"), error);
                }
            } else {
                TcpServer.log.error(ReactorNetty.format(connection.channel(), "onUncaughtException(" + connection + ")"), error);
            }
            connection.dispose();
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == ConnectionObserver.State.DISCONNECTING && connection.channel().isActive() && !connection.isPersistent()) {
                connection.dispose();
            }
            this.childObs.onStateChange(connection, newState);
        }
    }

    static final class DisposableBind
    implements Disposable,
    ChannelFutureListener,
    DisposableServer,
    Connection {
        final MonoSink<DisposableServer> sink;
        final ChannelFuture f;
        final ServerBootstrap bootstrap;
        final ConnectionObserver selectorObserver;

        DisposableBind(MonoSink<DisposableServer> sink, ChannelFuture f, ConnectionObserver selectorObserver, ServerBootstrap bootstrap) {
            this.sink = sink;
            this.bootstrap = bootstrap;
            this.f = f;
            this.selectorObserver = selectorObserver;
        }

        @Override
        public final void dispose() {
            this.f.removeListener(this);
            if (this.f.channel().isActive()) {
                this.f.channel().close();
                HttpResources.get().disposeWhen(this.bootstrap.config().localAddress());
            } else if (!this.f.isDone()) {
                this.f.cancel(true);
            }
        }

        @Override
        public Channel channel() {
            return this.f.channel();
        }

        @Override
        public final void operationComplete(ChannelFuture f) {
            if (!f.isSuccess()) {
                if (f.isCancelled()) {
                    if (TcpServer.log.isDebugEnabled()) {
                        TcpServer.log.debug(ReactorNetty.format(f.channel(), "Channel cancelled"));
                    }
                    return;
                }
                this.sink.error(ChannelBindException.fail(this.bootstrap, f.cause()));
            } else {
                if (TcpServer.log.isDebugEnabled()) {
                    TcpServer.log.debug(ReactorNetty.format(f.channel(), "Bound new server"));
                }
                this.sink.success(this);
                this.selectorObserver.onStateChange(this, ConnectionObserver.State.CONNECTED);
            }
        }
    }
}

