/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.spring.autoconfigure.MeterRegistryCustomizer;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;

class MeterRegistryConfigurer {
    private final ObjectProvider<List<MeterRegistryCustomizer<?>>> customizers;
    private final ObjectProvider<List<MeterFilter>> filters;
    private final ObjectProvider<List<MeterBinder>> binders;
    private final boolean addToGlobalRegistry;

    MeterRegistryConfigurer(ObjectProvider<List<MeterRegistryCustomizer<?>>> customizers, ObjectProvider<List<MeterFilter>> filters, ObjectProvider<List<MeterBinder>> binders, boolean addToGlobalRegistry) {
        this.customizers = customizers;
        this.filters = filters;
        this.binders = binders;
        this.addToGlobalRegistry = addToGlobalRegistry;
    }

    void configure(MeterRegistry registry) {
        this.customize(registry);
        this.addFilters(registry);
        this.addBinders(registry);
        if (this.addToGlobalRegistry && registry != Metrics.globalRegistry) {
            Metrics.addRegistry((MeterRegistry)registry);
        }
    }

    private void customize(MeterRegistry registry) {
        for (MeterRegistryCustomizer<?> customizer : this.getOrEmpty(this.customizers)) {
            try {
                customizer.customize(registry);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    private void addFilters(MeterRegistry registry) {
        this.getOrEmpty(this.filters).forEach(arg_0 -> ((MeterRegistry.Config)registry.config()).meterFilter(arg_0));
    }

    private void addBinders(MeterRegistry registry) {
        this.getOrEmpty(this.binders).forEach(binder -> binder.bindTo(registry));
    }

    private <T> List<T> getOrEmpty(ObjectProvider<List<T>> listProvider) {
        List list = (List)listProvider.getIfAvailable();
        return list != null ? list : Collections.emptyList();
    }
}

