/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure;

import io.micrometer.spring.autoconfigure.ServiceLevelAgreementBoundary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="management.metrics")
public class MetricsProperties {
    private final Web web = new Web();
    private final Distribution distribution = new Distribution();
    private final Map<String, Boolean> enable = new HashMap<String, Boolean>();
    private final Map<String, String> tags = new LinkedHashMap<String, String>();
    private boolean useGlobalRegistry = true;

    public boolean isUseGlobalRegistry() {
        return this.useGlobalRegistry;
    }

    public void setUseGlobalRegistry(boolean useGlobalRegistry) {
        this.useGlobalRegistry = useGlobalRegistry;
    }

    public Web getWeb() {
        return this.web;
    }

    public Map<String, Boolean> getEnable() {
        return this.enable;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public static class Distribution {
        private final Map<String, Boolean> percentilesHistogram = new LinkedHashMap<String, Boolean>();
        private final Map<String, double[]> percentiles = new LinkedHashMap<String, double[]>();
        private final Map<String, ServiceLevelAgreementBoundary[]> sla = new LinkedHashMap<String, ServiceLevelAgreementBoundary[]>();
        private final Map<String, String> minimumExpectedValue = new LinkedHashMap<String, String>();
        private final Map<String, String> maximumExpectedValue = new LinkedHashMap<String, String>();

        public Map<String, Boolean> getPercentilesHistogram() {
            return this.percentilesHistogram;
        }

        public Map<String, double[]> getPercentiles() {
            return this.percentiles;
        }

        public Map<String, ServiceLevelAgreementBoundary[]> getSla() {
            return this.sla;
        }

        public Map<String, String> getMinimumExpectedValue() {
            return this.minimumExpectedValue;
        }

        public Map<String, String> getMaximumExpectedValue() {
            return this.maximumExpectedValue;
        }
    }

    public static class Web {
        private final Client client = new Client();
        private final Server server = new Server();

        public Client getClient() {
            return this.client;
        }

        public Server getServer() {
            return this.server;
        }

        public static class Server {
            private boolean autoTimeRequests = true;
            private String requestsMetricName = "http.server.requests";
            private int maxUriTags = 100;

            public boolean isAutoTimeRequests() {
                return this.autoTimeRequests;
            }

            public void setAutoTimeRequests(boolean autoTimeRequests) {
                this.autoTimeRequests = autoTimeRequests;
            }

            public String getRequestsMetricName() {
                return this.requestsMetricName;
            }

            public void setRequestsMetricName(String requestsMetricName) {
                this.requestsMetricName = requestsMetricName;
            }

            public int getMaxUriTags() {
                return this.maxUriTags;
            }

            public void setMaxUriTags(int maxUriTags) {
                this.maxUriTags = maxUriTags;
            }
        }

        public static class Client {
            private String requestsMetricName = "http.client.requests";
            private int maxUriTags = 100;

            public String getRequestsMetricName() {
                return this.requestsMetricName;
            }

            public void setRequestsMetricName(String requestsMetricName) {
                this.requestsMetricName = requestsMetricName;
            }

            public int getMaxUriTags() {
                return this.maxUriTags;
            }

            public void setMaxUriTags(int maxUriTags) {
                this.maxUriTags = maxUriTags;
            }
        }
    }
}

