/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.graphite;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteHierarchicalNameMapper;
import io.micrometer.graphite.GraphiteMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.graphite.GraphiteProperties;
import io.micrometer.spring.autoconfigure.export.graphite.GraphitePropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={GraphiteMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.graphite", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={GraphiteProperties.class})
@Import(value={StringToDurationConverter.class})
public class GraphiteMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GraphiteConfig graphiteConfig(GraphiteProperties props) {
        return new GraphitePropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public HierarchicalNameMapper graphiteHierarchicalNameMapper(GraphiteConfig config) {
        return new GraphiteHierarchicalNameMapper(config.tagsAsPrefix());
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphiteMeterRegistry graphiteMeterRegistry(GraphiteConfig config, Clock clock, HierarchicalNameMapper nameMapper) {
        return new GraphiteMeterRegistry(config, clock, nameMapper);
    }
}

