/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.prometheus.PrometheusProperties;
import io.micrometer.spring.autoconfigure.export.prometheus.PrometheusPropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import io.micrometer.spring.export.prometheus.PrometheusPushGatewayManager;
import io.micrometer.spring.export.prometheus.PrometheusScrapeEndpoint;
import io.micrometer.spring.export.prometheus.PrometheusScrapeMvcEndpoint;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.PushGateway;
import java.time.Duration;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={PrometheusMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.prometheus", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={PrometheusProperties.class})
@Import(value={StringToDurationConverter.class})
public class PrometheusMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PrometheusConfig prometheusConfig(PrometheusProperties props) {
        return new PrometheusPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public PrometheusMeterRegistry prometheusMeterRegistry(PrometheusConfig config, CollectorRegistry collectorRegistry, Clock clock) {
        return new PrometheusMeterRegistry(config, collectorRegistry, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public CollectorRegistry collectorRegistry() {
        return new CollectorRegistry(true);
    }

    @Configuration
    @ConditionalOnClass(value={PushGateway.class})
    @ConditionalOnProperty(prefix="management.metrics.export.prometheus.pushgateway", name={"enabled"})
    public static class PrometheusPushGatewayConfiguration {
        private static final String FALLBACK_JOB = "spring";

        @Bean
        @ConditionalOnMissingBean
        public PrometheusPushGatewayManager prometheusPushGatewayManager(CollectorRegistry collectorRegistry, PrometheusProperties prometheusProperties, Environment environment) {
            PrometheusProperties.Pushgateway properties = prometheusProperties.getPushgateway();
            PushGateway pushGateway = new PushGateway(properties.getBaseUrl());
            Duration pushRate = properties.getPushRate();
            String job = this.getJob(properties, environment);
            Map<String, String> groupingKey = properties.getGroupingKey();
            PrometheusPushGatewayManager.ShutdownOperation shutdownOperation = properties.getShutdownOperation();
            return new PrometheusPushGatewayManager(pushGateway, collectorRegistry, pushRate, job, groupingKey, shutdownOperation);
        }

        private String getJob(PrometheusProperties.Pushgateway properties, Environment environment) {
            String job = properties.getJob();
            job = job != null ? job : environment.getProperty("spring.application.name");
            return job != null ? job : FALLBACK_JOB;
        }
    }

    @ManagementContextConfiguration
    @ConditionalOnClass(value={AbstractEndpoint.class})
    public static class PrometheusScrapeEndpointConfiguration {
        @Bean
        public PrometheusScrapeEndpoint prometheusEndpoint(CollectorRegistry collectorRegistry) {
            return new PrometheusScrapeEndpoint(collectorRegistry);
        }

        @Bean
        @ConditionalOnEnabledEndpoint(value="prometheus")
        public PrometheusScrapeMvcEndpoint prometheusMvcEndpoint(PrometheusScrapeEndpoint delegate) {
            return new PrometheusScrapeMvcEndpoint(delegate);
        }
    }
}

