/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.DefaultApplicationContextBuilder;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.naming.Described;
import io.micronaut.runtime.EmbeddedApplication;
import io.micronaut.runtime.exceptions.ApplicationStartupException;
import io.micronaut.runtime.server.EmbeddedServer;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Micronaut
extends DefaultApplicationContextBuilder
implements ApplicationContextBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(Micronaut.class);
    private static final String SHUTDOWN_MONITOR_THREAD = "micronaut-shutdown-monitor-thread";
    private Map<Class<? extends Throwable>, Function<Throwable, Integer>> exitHandlers = new LinkedHashMap<Class<? extends Throwable>, Function<Throwable, Integer>>();

    protected Micronaut() {
    }

    @NonNull
    public ApplicationContext start() {
        long start = System.currentTimeMillis();
        ApplicationContext applicationContext = super.build();
        try {
            applicationContext.start();
            Optional embeddedContainerBean = applicationContext.findBean(EmbeddedApplication.class);
            embeddedContainerBean.ifPresent(embeddedApplication -> {
                try {
                    long took;
                    embeddedApplication.start();
                    boolean keepAlive = false;
                    if (embeddedApplication instanceof Described) {
                        if (LOG.isInfoEnabled()) {
                            long end = System.currentTimeMillis();
                            took = end - start;
                            String desc = ((Described)embeddedApplication).getDescription();
                            LOG.info("Startup completed in {}ms. Server Running: {}", (Object)took, (Object)desc);
                        }
                        keepAlive = embeddedApplication.isServer();
                    } else if (embeddedApplication instanceof EmbeddedServer) {
                        EmbeddedServer embeddedServer = (EmbeddedServer)embeddedApplication;
                        if (LOG.isInfoEnabled()) {
                            long end = System.currentTimeMillis();
                            long took2 = end - start;
                            URL url = embeddedServer.getURL();
                            LOG.info("Startup completed in {}ms. Server Running: {}", (Object)took2, (Object)url);
                        }
                        keepAlive = embeddedServer.isKeepAlive();
                    } else {
                        if (LOG.isInfoEnabled()) {
                            long end = System.currentTimeMillis();
                            took = end - start;
                            LOG.info("Startup completed in {}ms.", (Object)took);
                        }
                        keepAlive = embeddedApplication.isServer();
                    }
                    Thread mainThread = Thread.currentThread();
                    boolean finalKeepAlive = keepAlive;
                    CountDownLatch countDownLatch = new CountDownLatch(1);
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Embedded Application shutting down");
                        }
                        if (embeddedApplication.isRunning()) {
                            embeddedApplication.stop();
                            countDownLatch.countDown();
                            if (finalKeepAlive) {
                                mainThread.interrupt();
                            }
                        }
                    }));
                    if (keepAlive) {
                        new Thread(() -> {
                            try {
                                if (!embeddedApplication.isRunning()) {
                                    countDownLatch.countDown();
                                    Thread.sleep(1000L);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }, SHUTDOWN_MONITOR_THREAD).start();
                        try {
                            countDownLatch.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Embedded Application shutting down");
                        }
                    }
                    if (embeddedApplication.isForceExit()) {
                        System.exit(0);
                    }
                }
                catch (Throwable e) {
                    this.handleStartupException(applicationContext.getEnvironment(), e);
                }
            });
            if (LOG.isInfoEnabled() && !embeddedContainerBean.isPresent()) {
                LOG.info("No embedded container found. Running as CLI application");
            }
            return applicationContext;
        }
        catch (Throwable e) {
            this.handleStartupException(applicationContext.getEnvironment(), e);
            return null;
        }
    }

    @NonNull
    public Micronaut include(String ... configurations) {
        return (Micronaut)super.include(configurations);
    }

    @NonNull
    public Micronaut exclude(String ... configurations) {
        return (Micronaut)super.exclude(configurations);
    }

    @NonNull
    public Micronaut classes(Class ... classes) {
        if (classes != null) {
            for (Class aClass : classes) {
                this.packages(aClass.getPackage().getName());
            }
        }
        return this;
    }

    @NonNull
    public Micronaut properties(@Nullable Map<String, Object> properties) {
        return (Micronaut)super.properties(properties);
    }

    @NonNull
    public Micronaut singletons(Object ... beans) {
        return (Micronaut)super.singletons(beans);
    }

    @NonNull
    public Micronaut propertySources(PropertySource ... propertySources) {
        return (Micronaut)super.propertySources(propertySources);
    }

    @NonNull
    public Micronaut environmentPropertySource(boolean environmentPropertySource) {
        return (Micronaut)super.environmentPropertySource(environmentPropertySource);
    }

    @NonNull
    public Micronaut environmentVariableIncludes(String ... environmentVariables) {
        return (Micronaut)super.environmentVariableIncludes(environmentVariables);
    }

    @NonNull
    public Micronaut environmentVariableExcludes(String ... environmentVariables) {
        return (Micronaut)super.environmentVariableExcludes(environmentVariables);
    }

    @NonNull
    public Micronaut mainClass(Class mainClass) {
        return (Micronaut)super.mainClass(mainClass);
    }

    @NonNull
    public Micronaut classLoader(ClassLoader classLoader) {
        return (Micronaut)super.classLoader(classLoader);
    }

    @NonNull
    public Micronaut args(String ... args) {
        return (Micronaut)super.args(args);
    }

    @NonNull
    public Micronaut environments(String ... environments) {
        return (Micronaut)super.environments(environments);
    }

    @NonNull
    public Micronaut defaultEnvironments(String ... environments) {
        return (Micronaut)super.defaultEnvironments(environments);
    }

    @NonNull
    public Micronaut packages(String ... packages) {
        return (Micronaut)super.packages(packages);
    }

    public <T extends Throwable> Micronaut mapError(Class<T> exception, Function<T, Integer> mapper) {
        this.exitHandlers.put(exception, mapper);
        return this;
    }

    public static Micronaut build(String ... args) {
        return new Micronaut().args(args);
    }

    public static ApplicationContext run(String ... args) {
        return Micronaut.run(new Class[0], args);
    }

    public static ApplicationContext run(Class cls, String ... args) {
        return Micronaut.run(new Class[]{cls}, args);
    }

    public static ApplicationContext run(Class[] classes, String ... args) {
        return new Micronaut().classes(classes).args(args).start();
    }

    protected void handleStartupException(Environment environment, Throwable exception) {
        Function exitCodeMapper = this.exitHandlers.computeIfAbsent(exception.getClass(), exceptionType -> throwable -> 1);
        Integer code = (Integer)exitCodeMapper.apply(exception);
        if (code > 0 && !environment.getActiveNames().contains("test")) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error starting Micronaut server: " + exception.getMessage(), exception);
            }
            System.exit(code);
        }
        throw new ApplicationStartupException("Error starting Micronaut server: " + exception.getMessage(), exception);
    }
}

