/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.reactor.instrument;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.ReactiveInvocationInstrumenterFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Requirements(value={@Requires(sdk=Requires.Sdk.MICRONAUT, version="2.0.0"), @Requires(classes={Flux.class, Schedulers.Factory.class})})
@Context
@Internal
class ReactorInstrumentation {
    ReactorInstrumentation() {
    }

    @PostConstruct
    void init(BeanContext beanContext, ReactorInstrumenterFactory instrumenterFactory) {
        Schedulers.onScheduleHook((String)"reactor-micronaut-instrumentation", runnable -> {
            InvocationInstrumenter instrumenter;
            if (instrumenterFactory.hasInstrumenters() && (instrumenter = instrumenterFactory.create()) != null) {
                return () -> {
                    try (Instrumentation ignored = instrumenter.newInstrumentation();){
                        runnable.run();
                    }
                };
            }
            return runnable;
        });
    }

    @PreDestroy
    void removeInstrumentation() {
        Schedulers.removeExecutorServiceDecorator((String)"micronaut");
    }

    @Context
    @Requires(classes={Flux.class})
    @Internal
    static final class ReactorInstrumenterFactory {
        private final List<ReactiveInvocationInstrumenterFactory> reactiveInvocationInstrumenterFactories;

        ReactorInstrumenterFactory(List<ReactiveInvocationInstrumenterFactory> reactiveInvocationInstrumenterFactories) {
            this.reactiveInvocationInstrumenterFactories = reactiveInvocationInstrumenterFactories;
        }

        public boolean hasInstrumenters() {
            return !this.reactiveInvocationInstrumenterFactories.isEmpty();
        }

        @Nullable
        public InvocationInstrumenter create() {
            List<InvocationInstrumenter> invocationInstrumenter = this.getReactiveInvocationInstrumenters();
            if (CollectionUtils.isNotEmpty(invocationInstrumenter)) {
                return InvocationInstrumenter.combine(invocationInstrumenter);
            }
            return null;
        }

        private List<InvocationInstrumenter> getReactiveInvocationInstrumenters() {
            ArrayList<InvocationInstrumenter> instrumenters = new ArrayList<InvocationInstrumenter>(this.reactiveInvocationInstrumenterFactories.size());
            for (ReactiveInvocationInstrumenterFactory instrumenterFactory : this.reactiveInvocationInstrumenterFactories) {
                InvocationInstrumenter instrumenter = instrumenterFactory.newReactiveInvocationInstrumenter();
                if (instrumenter == null) continue;
                instrumenters.add(instrumenter);
            }
            return instrumenters;
        }
    }
}

