/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.connection;

import io.milvus.connection.ClusterFactory;
import io.milvus.connection.ClusterListener;
import io.milvus.connection.Listener;
import io.milvus.connection.QueryNodeListener;
import io.milvus.connection.ServerSetting;
import io.milvus.param.QueryNodeSingleSearch;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMonitor {
    private static final Logger logger = LoggerFactory.getLogger(ServerMonitor.class);
    private static final long heartbeatInterval = 10000L;
    private Long lastHeartbeat;
    private final List<Listener> listeners;
    private final ClusterFactory clusterFactory;
    private final Thread monitorThread;
    private volatile boolean isRunning;

    public ServerMonitor(ClusterFactory clusterFactory, QueryNodeSingleSearch queryNodeSingleSearch) {
        this.listeners = null != queryNodeSingleSearch ? Arrays.asList(new ClusterListener(), new QueryNodeListener(queryNodeSingleSearch)) : Collections.singletonList(new ClusterListener());
        this.clusterFactory = clusterFactory;
        ServerMonitorRunnable monitor = new ServerMonitorRunnable();
        this.monitorThread = new Thread((Runnable)monitor, "Milvus-server-monitor");
        this.monitorThread.setDaemon(true);
        this.isRunning = true;
    }

    public void start() {
        logger.info("Milvus Server Monitor start.");
        this.monitorThread.start();
    }

    public void close() {
        this.isRunning = false;
        logger.info("Milvus Server Monitor close.");
        this.monitorThread.interrupt();
    }

    private class ServerMonitorRunnable
    implements Runnable {
        private ServerMonitorRunnable() {
        }

        @Override
        public void run() {
            while (ServerMonitor.this.isRunning) {
                long timeTillNextCheck;
                long startTime = System.currentTimeMillis();
                if (null == ServerMonitor.this.lastHeartbeat || (timeTillNextCheck = ServerMonitor.this.lastHeartbeat + 10000L - startTime) <= 0L) {
                    ServerMonitor.this.lastHeartbeat = startTime;
                    try {
                        List<ServerSetting> availableServer = this.getAvailableServer();
                        ServerMonitor.this.clusterFactory.availableServerChange(availableServer);
                    }
                    catch (Exception e) {
                        logger.error("Milvus Server Heartbeat error, monitor will stop.", (Throwable)e);
                    }
                    if (!ServerMonitor.this.clusterFactory.masterIsRunning()) {
                        ServerSetting master = ServerMonitor.this.clusterFactory.electMaster();
                        logger.warn("Milvus Server Heartbeat. Master is Not Running, Re-Elect [{}] to master.", (Object)master.getServerAddress().getHost());
                        ServerMonitor.this.clusterFactory.masterChange(master);
                        continue;
                    }
                    logger.debug("Milvus Server Heartbeat. Master is Running.");
                    continue;
                }
                try {
                    Thread.sleep(timeTillNextCheck);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Milvus Server Heartbeat. Interrupted.");
                    throw new RuntimeException(e);
                }
            }
        }

        private List<ServerSetting> getAvailableServer() {
            return ServerMonitor.this.clusterFactory.getServerSettings().stream().filter(this::checkServerState).collect(Collectors.toList());
        }

        private boolean checkServerState(ServerSetting serverSetting) {
            for (Listener listener : ServerMonitor.this.listeners) {
                boolean isRunning = listener.heartBeat(serverSetting);
                if (isRunning) continue;
                return false;
            }
            return true;
        }
    }
}

