/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ServerAddress {
    private final String host;
    private final int port;
    private final int healthPort;

    private ServerAddress(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.host = builder.host;
        this.port = builder.port;
        this.healthPort = builder.healthPort;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getHealthPort() {
        return this.healthPort;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ServerAddress{");
        sb.append("host='").append(this.host).append('\'');
        sb.append(", port=").append(this.port);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerAddress that = (ServerAddress)o;
        return new EqualsBuilder().append(this.port, that.port).append((Object)this.host, (Object)that.host).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.host).append(this.port).toHashCode();
    }

    public static class Builder {
        private String host = "localhost";
        private int port = 19530;
        private int healthPort = 9091;

        private Builder() {
        }

        public Builder withHost(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            this.host = host;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withHealthPort(int port) {
            this.healthPort = port;
            return this;
        }

        public ServerAddress build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.host, "Host name");
            if (this.port < 0 || this.port > 65535) {
                throw new ParamException("Port is out of range!");
            }
            if (this.healthPort < 0 || this.healthPort > 65535) {
                throw new ParamException("Health Port is out of range!");
            }
            return new ServerAddress(this);
        }
    }
}

