/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.control;

import io.milvus.exception.ParamException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class LoadBalanceParam {
    private final String databaseName;
    private final String collectionName;
    private final Long srcNodeID;
    private final List<Long> destNodeIDs;
    private final List<Long> segmentIDs;

    private LoadBalanceParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.srcNodeID = builder.srcNodeID;
        this.destNodeIDs = builder.destNodeIDs;
        this.segmentIDs = builder.segmentIDs;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Long getSrcNodeID() {
        return this.srcNodeID;
    }

    public List<Long> getDestNodeIDs() {
        return this.destNodeIDs;
    }

    public List<Long> getSegmentIDs() {
        return this.segmentIDs;
    }

    public String toString() {
        return "LoadBalanceParam(databaseName=" + this.getDatabaseName() + ", collectionName=" + this.getCollectionName() + ", srcNodeID=" + this.getSrcNodeID() + ", destNodeIDs=" + this.getDestNodeIDs() + ", segmentIDs=" + this.getSegmentIDs() + ")";
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;
        private final List<Long> destNodeIDs = new ArrayList<Long>();
        private final List<Long> segmentIDs = new ArrayList<Long>();
        private Long srcNodeID;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withSourceNodeID(@NonNull Long srcNodeID) {
            if (srcNodeID == null) {
                throw new NullPointerException("srcNodeID is marked non-null but is null");
            }
            this.srcNodeID = srcNodeID;
            return this;
        }

        public Builder addDestinationNodeID(@NonNull Long destNodeID) {
            if (destNodeID == null) {
                throw new NullPointerException("destNodeID is marked non-null but is null");
            }
            if (!this.destNodeIDs.contains(destNodeID)) {
                this.destNodeIDs.add(destNodeID);
            }
            return this;
        }

        public Builder withDestinationNodeID(@NonNull List<Long> destNodeIDs) {
            if (destNodeIDs == null) {
                throw new NullPointerException("destNodeIDs is marked non-null but is null");
            }
            destNodeIDs.forEach(this::addDestinationNodeID);
            return this;
        }

        public Builder addSegmentID(@NonNull Long segmentID) {
            if (segmentID == null) {
                throw new NullPointerException("segmentID is marked non-null but is null");
            }
            if (!this.segmentIDs.contains(segmentID)) {
                this.segmentIDs.add(segmentID);
            }
            return this;
        }

        public Builder withSegmentIDs(@NonNull List<Long> segmentIDs) {
            if (segmentIDs == null) {
                throw new NullPointerException("segmentIDs is marked non-null but is null");
            }
            segmentIDs.forEach(this::addSegmentID);
            return this;
        }

        public LoadBalanceParam build() throws ParamException {
            if (this.segmentIDs.isEmpty()) {
                throw new ParamException("Sealed segment id array cannot be empty");
            }
            if (this.destNodeIDs.isEmpty()) {
                throw new ParamException("Destination query node id array cannot be empty");
            }
            return new LoadBalanceParam(this);
        }
    }
}

